package com.kurukurupapa.tryandroidui.draglist;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import android.widget.ImageView;

/**
 * ドラッグ中の項目を表すビュー
 */
public class DragListImageView extends ImageView {
	private static final Bitmap.Config DRAG_BITMAP_CONFIG = Bitmap.Config.ARGB_8888;

	/**
	 * コンストラクタ
	 */
	public DragListImageView(Context context, View itemView) {
		super(context);
		setImageBitmap(createBitmap(itemView));
	}

	/**
	 * ドラッグ対象項目のViewを描画
	 */
	private Bitmap createBitmap(View itemView) {
		Bitmap bitmap = Bitmap.createBitmap(itemView.getWidth(),
				itemView.getHeight(), DRAG_BITMAP_CONFIG);
		Canvas canvas = new Canvas();
		canvas.setBitmap(bitmap);
		itemView.draw(canvas);
		return bitmap;
	}

}
