/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.io;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.seasar.util.collection.CollectionsUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class ResourceBundleUtil {
    public static final ResourceBundle getBundle(String name) {
        AssertionUtil.assertArgumentNotEmpty("name", name);
        try {
            return ResourceBundle.getBundle(name);
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    public static final ResourceBundle getBundle(String name, Locale locale) {
        AssertionUtil.assertArgumentNotEmpty("name", name);
        try {
            return ResourceBundle.getBundle(name, ResourceBundleUtil.getLocale(locale));
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    public static final ResourceBundle getBundle(String name, Locale locale, ClassLoader classLoader) {
        AssertionUtil.assertArgumentNotNull("name", name);
        AssertionUtil.assertArgumentNotNull("classLoader", classLoader);
        try {
            return ResourceBundle.getBundle(name, ResourceBundleUtil.getLocale(locale), classLoader);
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    public static String getString(ResourceBundle bundle, String key) {
        AssertionUtil.assertArgumentNotNull("bundle", bundle);
        AssertionUtil.assertArgumentNotEmpty("key", key);
        try {
            return bundle.getString(key);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static final Map<String, String> convertMap(ResourceBundle bundle) {
        AssertionUtil.assertArgumentNotNull("bundle", bundle);
        HashMap<String, String> ret = CollectionsUtil.newHashMap();
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = bundle.getString(key);
            ret.put(key, value);
        }
        return ret;
    }

    public static final Map<String, String> convertMap(String name, Locale locale) {
        AssertionUtil.assertArgumentNotEmpty("name", name);
        ResourceBundle bundle = ResourceBundleUtil.getBundle(name, locale);
        return ResourceBundleUtil.convertMap(bundle);
    }

    protected static Locale getLocale(Locale locale) {
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }
}

