package com.tryandroid;

import com.kurukurupapa.tryandroid.fw.util.ActivityUtil;
import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.tryandroid.R;
import com.tryandroid.battery.BatteryActivity;
import com.tryandroid.battery.BatteryWatchingActivity;
import com.tryandroid.etc.AppListActivity;
import com.tryandroid.file.FileActivity;
import com.tryandroid.hello.HelloActivity;
import com.tryandroid.mail.MailSendActivity;
import com.tryandroid.media.CameraPlayActivity;
import com.tryandroid.media.CameraRecActivity;
import com.tryandroid.media.VideoRecActivity;
import com.tryandroid.preference.MyPreferenceActivity;
import com.tryandroid.preference2.Pref21Activity;
import com.tryandroid.sensor.SensorActivity;
import com.tryandroid.sensor.SensorListActivity;

import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;

public class TryAndroid extends ListActivity {
	private static final int MENU_ID_ABOUT = 0;

	protected static final int REQUESTCODE_HELLO = 0;
	protected static final int REQUESTCODE_BATTERY = 1;
	protected static final int REQUESTCODE_SENSOR_LIST = 2;
	protected static final int REQUESTCODE_SENSOR = 3;
	// protected static final int REQUESTCODE_DB = 4;
	// protected static final int REQUESTCODE_DB2 = 5;
	protected static final int REQUESTCODE_PREFERENCE = 6;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		LogUtil.called();

		super.onCreate(savedInstanceState);
		MapList list = new MapList();

		// Hello
		list.add("Hello", new Intent(TryAndroid.this, HelloActivity.class),
				REQUESTCODE_HELLO);

		// Battery
		list.add("Battery", new Intent(TryAndroid.this, BatteryActivity.class),
				REQUESTCODE_BATTERY);
		list.add("Battery監視", new Intent(TryAndroid.this,
				BatteryWatchingActivity.class));

		// SensorList
		list.add("SensorList", new Intent(TryAndroid.this,
				SensorListActivity.class), REQUESTCODE_SENSOR_LIST);

		// Sensor
		list.add("Sensor", new Intent(TryAndroid.this, SensorActivity.class),
				REQUESTCODE_SENSOR);

		// Preference
		list.add("Preference", new Intent(TryAndroid.this,
				MyPreferenceActivity.class), REQUESTCODE_PREFERENCE);

		// Preference2
		list.add("Preference2", new Intent(TryAndroid.this,
				Pref21Activity.class), 0);

		// File
		list.add("File", new Intent(TryAndroid.this, FileActivity.class), 0);

		// MailSend
		list.add("MailSend",
				new Intent(TryAndroid.this, MailSendActivity.class), 0);

		// Media
		list.add("CameraRec", new Intent(TryAndroid.this,
				CameraRecActivity.class), 0);
		list.add("CameraPlay", new Intent(TryAndroid.this,
				CameraPlayActivity.class), 0);
		list.add("VideoRec",
				new Intent(TryAndroid.this, VideoRecActivity.class), 0);

		// Etc
		list.add("アプリ一覧", new Intent(TryAndroid.this, AppListActivity.class), 0);

		setListAdapter(ActivityUtil.createTestListItemAdapter(this, list,
				list.getTextKey()));
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		LogUtil.called();

		boolean result = super.onCreateOptionsMenu(menu);
		MenuItem item = menu.add(0, MENU_ID_ABOUT, 0, R.string.menu_about);
		item.setIcon(android.R.drawable.ic_menu_info_details);
		return result;
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see android.app.Activity#onOptionsItemSelected(android.view.MenuItem)
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		LogUtil.called();

		if (super.onOptionsItemSelected(item)) {
			return true;
		}

		switch (item.getItemId()) {
		case MENU_ID_ABOUT:

			return true;
		}

		return false;
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see android.app.ListActivity#onListItemClick(android.widget.ListView,
	 * android.view.View, int, long)
	 */
	@Override
	protected void onListItemClick(ListView l, View v, int position, long id) {
		ItemMap map = (ItemMap) l.getItemAtPosition(position);
		startActivityForResult(map.getIntent(), map.getRequestCode());
	}

}