package com.tryandroid.media;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.tryandroid.R;

import android.content.Context;
import android.os.Environment;

public class KomadoriUtil {
	private static SimpleDateFormat timestampFormat = new SimpleDateFormat(
			"yyyyMMdd-HHmmss");

	public static String getWorkName() {
		return "Komadori_"
				+ timestampFormat.format(new Date(System.currentTimeMillis()));
	}

	public static String getJpgFileName(int index) {
		return "Photo-" + String.format("%07d", index) + ".jpg";
		// return "Photo-"
		// + timestampFormat.format(new Date(System.currentTimeMillis()))
		// + ".jpg";
	}

	public static File getBaseDir(Context context, String workName) {
		File storageDir = Environment.getExternalStorageDirectory();
		File baseDir = new File(new File(storageDir,
				context.getString(R.string.app_name)), workName);
		return baseDir;
	}

	public static String getJpgFilePath(Context context, String workName,
			int index) {
		return new File(getBaseDir(context, workName), getJpgFileName(index))
				.getAbsolutePath();
	}
}
