package com.kurukurupapa.tryandroid.apt002;

import java.util.ArrayList;
import java.util.List;

import com.kurukurupapa.tryandroid.apt.util.MiniStringUtil;

public class TableData {
	private String srcPackageName;
	private String srcSimpleName;
	private String destPackageName;
	private String destSimpleName;
	private String tableName;
	private List<FieldData> fieldList;

	public TableData() {
		fieldList = new ArrayList<FieldData>();
	}

	public void addField(String type, String name) {
		FieldData fieldData = new FieldData(type, name);
		fieldList.add(fieldData);
	}

	public String getSrcClassName() {
		return srcPackageName + "." + srcSimpleName;
	}

	public String getDestClassName() {
		return destPackageName + "." + destSimpleName;
	}

	public String getSrcPackageName() {
		return srcPackageName;
	}

	public void setSrcPackageName(String srcPackageName) {
		this.srcPackageName = srcPackageName;
	}

	public String getSrcSimpleName() {
		return srcSimpleName;
	}

	public void setSrcSimpleName(String srcSimpleName) {
		this.srcSimpleName = srcSimpleName;
		this.tableName = MiniStringUtil.decamelizeAsLowerCase(srcSimpleName);
	}

	public String getDestPackageName() {
		return destPackageName;
	}

	public void setDestPackageName(String destPackageName) {
		this.destPackageName = destPackageName;
	}

	public String getDestSimpleName() {
		return destSimpleName;
	}

	public void setDestSimpleName(String destSimpleName) {
		this.destSimpleName = destSimpleName;
	}

	public List<FieldData> getFieldList() {
		return fieldList;
	}

	public void addField(FieldData field) {
		this.fieldList.add(field);
	}

	public String getTableName() {
		return tableName;
	}

}
