package com.kurukurupapa.tryandroiddb.db001;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DatabaseHelper extends SQLiteOpenHelper {
	private static final String DB_NAME = "db";
	private static final int DB_VERSION = 1;

	public DatabaseHelper(Context context) {
		super(context, DB_NAME, null, DB_VERSION);
	}

	@Override
	public void onCreate(SQLiteDatabase sqlitedatabase) {
		LogUtil.called();
		sqlitedatabase.execSQL("create table record (" //
				+ "id integer primary key autoincrement," //
				+ "text text not null," //
				+ "date text not null" //
				+ ")");
	}

	@Override
	public void onUpgrade(SQLiteDatabase sqlitedatabase, int oldVersion,
			int newVersion) {
		LogUtil.called();
		sqlitedatabase.execSQL("drop table if exists record");
		onCreate(sqlitedatabase);
	}

}
