package com.kurukurupapa.tryandroidui.draglist;


import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

/**
 * ドラッグアンドドロップで並び替え可能なリストビュー用のデータアダプター（リスト項目は１つのテキスト）
 */
public class DragListAdapter1 extends DragListAdapter {
	private Activity mActivity;
	private String[] mItems;

	public DragListAdapter1(String[] items, Activity activity) {
		mItems = items;
		mActivity = activity;
	}

	@Override
	public int getCount() {
		return mItems.length;
	}

	@Override
	public Object getItem(int position) {
		return mItems[position];
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	protected View getNormalView(int position, View convertView,
			ViewGroup parent) {
		if (convertView == null) {
			convertView = mActivity.getLayoutInflater().inflate(
					android.R.layout.simple_list_item_1, null);
		}
		TextView view = (TextView) convertView;
		view.setText(mItems[position]);
		return convertView;
	}

	@Override
	public void swapItems(int position1, int position2) {
		String tmp = mItems[position1];
		mItems[position1] = mItems[position2];
		mItems[position2] = tmp;
	}

}
