package com.kurukurupapa.tryandroidui.draglist;


/**
 * ドラッグアンドドロップで並び替え可能なリストビュー用のデータ処理リスナー
 */
public class DragListListener {
	private DragListAdapter mAdapter;

	public DragListListener(DragListAdapter adapter) {
		mAdapter = adapter;
	}

	public void onStartDrag(int position) {
		// アダプターにドラッグ対象項目位置を渡す
		mAdapter.setDraggingPosition(position);
	}

	public void onDuringDrag(int positionFrom, int positionTo) {
		if (positionFrom < 0 || positionTo < 0 || positionFrom == positionTo) {
			return;
		}

		if (positionFrom < positionTo) {
			// リスト項目を下に移動している場合
			for (int i = positionFrom; i < positionTo; i++) {
				mAdapter.swapItems(i, i + 1);
			}

		} else if (positionFrom > positionTo) {
			// リスト項目を上に移動している場合
			for (int i = positionFrom; i > positionTo; i--) {
				mAdapter.swapItems(i, i - 1);
			}
		}

		// アダプターにドラッグ対象項目位置を渡す
		mAdapter.setDraggingPosition(positionTo);
	}

	public void onStopDrag() {
		// アダプターにドラッグ対象なしを渡す
		mAdapter.setDraggingPosition(-1);
	}
}
