package com.tryandroid.media;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.tryandroid.R;

import android.app.Activity;
import android.os.Bundle;
import android.view.SurfaceView;
import android.view.View;
import android.widget.TextView;

/**
 * コマ撮り用のアクティビティ
 */
public class KomadoriActivity extends Activity {

	/**
	 * 作品名
	 */
	private String workName;

	private SurfaceView cameraView;
	private SurfaceView playView;
	private CameraViewHelper cameraViewHelper;
	private PlayViewHelper playViewHelper;
	private TextView workTextView;
	private TextView indexTextView;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		LogUtil.called();

		// レイアウトを設定
		setContentView(R.layout.koma_dori_activity);
		cameraView = (SurfaceView) findViewById(R.id.camera_view);
		playView = (SurfaceView) findViewById(R.id.play_view);
		workTextView = (TextView) findViewById(R.id.work_text_view);
		indexTextView = (TextView) findViewById(R.id.index_text_view);

		// ヘルパークラス作成
		workName = KomadoriUtil.getWorkName();
		cameraViewHelper = new CameraViewHelper(this, cameraView, workTextView,
				indexTextView);
		playViewHelper = new PlayViewHelper(this, playView, workTextView,
				indexTextView);

		onRecModeButtonClick(null);
	}

	public void onRecModeButtonClick(View view) {
		LogUtil.called();

		// 対象ビューの表示制御
		cameraView.setVisibility(View.VISIBLE);
		playView.setVisibility(View.GONE);

		cameraViewHelper.setWorkName(workName);
	}

	public void onPlayModeButtonClick(View view) {
		LogUtil.called();

		// 対象ビューの表示制御
		cameraView.setVisibility(View.GONE);
		playView.setVisibility(View.VISIBLE);

		playViewHelper.setWorkName(workName);
	}

}
