/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.crypto.impl;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.seasar.util.crypto.CipherContext;
import org.seasar.util.exception.InvalidKeyRuntimeException;
import org.seasar.util.exception.NoSuchAlgorithmRuntimeException;
import org.seasar.util.exception.NoSuchPaddingRuntimeException;
import org.seasar.util.exception.SIllegalStateException;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.misc.Base64Util;

public class CipherContextImpl
implements CipherContext {
    private final String algorithm;
    private final String key;
    private final String id;

    public CipherContextImpl(String algorithm, String key) {
        AssertionUtil.assertArgumentNotNull("algorithm", algorithm);
        AssertionUtil.assertArgumentNotNull("key", key);
        this.algorithm = algorithm;
        this.key = key;
        try {
            this.id = Base64Util.encode((this.getClass().getName() + algorithm + key).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SIllegalStateException(e);
        }
    }

    @Override
    public Cipher getCipher(int opmode) {
        SecretKeySpec sksSpec = new SecretKeySpec(this.key.getBytes(), this.algorithm);
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(opmode, sksSpec);
            return cipher;
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmRuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new NoSuchPaddingRuntimeException(e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

