package com.kurukurupapa.tryandroid.apt002;

import java.nio.charset.Charset;
import java.util.Locale;

import org.seasar.aptina.unit.AptinaTestCase;

public class DaoGeneraterTest extends AptinaTestCase {

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		// 言語設定
		setLocale(Locale.JAPANESE);
		setCharset(Charset.forName("UTF-8"));

		// ソースパスを追加
		addSourcePath("test");
	}

	public void testSimple() throws Exception {
		// テスト対象の Annotation Processor を生成して追加
		TryAndroidProcesser processor = new TryAndroidProcesser();
		addProcessor(processor);

		// コンパイル対象を追加
		addCompilationUnit(SimpleEntity.class);

		// コンパイル実行
		compile();

		// 結果確認
		assertEqualsGeneratedSourceWithFile(
				getExpectedFilePath("DaoGeneraterTest_Simple.txt"),
				"com.kurukurupapa.tryandroid.apt002.SimpleEntityDao");
	}

	private String getExpectedFilePath(String name) {
		String subPath = "/"
				+ getClass().getPackage().getName().replace('.', '/') + "/"
				+ name;
		return getClass().getResource(subPath).getPath();
	}

}
