package com.kurukurupapa.tryandroid.fw;

import java.lang.reflect.Field;

import com.kurukurupapa.tryandroid.fw.util.ReflectionUtil;

/**
 * フレームワーク例外クラス
 */
public class FwException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	public FwException(String msg) {
		super(msg);
	}

	public FwException(Exception e) {
		super(e);
	}

	public FwException(String msg, Exception e) {
		super(msg, e);
	}

	public FwException(Object obj, Field field, String msg) {
		this(obj, field, msg, null);
	}

	public FwException(Object obj, Field field, String msg, Exception e) {
		super("class=" + obj.getClass().getName() + ", field="
				+ field.getName() + ", object=" + ReflectionUtil.toString(obj)
				+ ", " + msg, e);
	}

}
