# Windows PowerShell
# eXgs

Set-StrictMode -Version Latest
$PSDefaultParameterValues = @{"ErrorAction"="Stop"}
$ErrorActionPreference = "Stop"
$WarningPreference = "Continue"
$DebugPreference = "Continue"
$baseDir = Convert-Path $(Split-Path $MyInvocation.InvocationName -Parent)
$psName = Split-Path $MyInvocation.InvocationName -Leaf
$timestamp = Get-Date -Format "yyyyMMdd-HHmmss"

######################################################################
### s
######################################################################

$sep = "#" * 70

Write-Output $sep

Invoke-Expression "$baseDir\StepCounter.ps1"

Write-Output $sep

$beforeDir = Join-Path $baseDir "TestData\StepCounter\before"
$afterDir = Join-Path $baseDir "TestData\StepCounter\after"
$outName = "StepCounterPs1"
Invoke-Expression "$baseDir\StepCounter.ps1 $beforeDir $afterDir $outName"

Write-Output $sep
