# Windows PowerShell
# ev[g

param($url, $outDir, $beforeRev, $afterRev, $beforeDir, $afterDir)

Set-StrictMode -Version Latest
$PSDefaultParameterValues = @{"ErrorAction"="Stop"}
$ErrorActionPreference = "Stop"
$WarningPreference = "Continue"
$VerbosePreference = "Continue"
$DebugPreference = "Continue"

######################################################################
### ֐`
######################################################################

# gp@o͂B
# return - Ȃ
function U-Write-Usage() {
    Write-Output "gF$psName SVNURL o̓fBNg [-BeforeRev ύXOrW] [-AfterRev ύXナrW] [-BeforeDir ύXO\[Xo̓fBNg] [-AfterDir ύX\[Xo̓fBNg]"
}

# 又sB
# return - Ȃ
function U-Run-Main() {
    if ($afterRev -eq $null) {
        $afterRev = "HEAD"
    }
    if ($beforeDir -eq $null) {
        $beforeDir = "${outDir}\BeforeSrc"
    }
    if ($afterDir -eq $null) {
        $afterDir = "${outDir}\AfterSrc"
    }

    U-Checkout-Source
    U-Create-DiffList
    
    Write-Output ""
    Write-Output "ύXO\[XfBNg=$beforeDir"
    Write-Output "ύX\[XfBNg=$afterDir"
    Write-Output "Xgt@C=$listPath"
}

function U-Checkout-Source() {
    Write-Verbose "`FbNAEgJn ${url}@${afterRev}"
    Invoke-Expression "svn co ${url}@${afterRev} $afterDir"
    
    if ($beforeRev -ne $null) {
        Write-Verbose "`FbNAEgJn ${url}@${beforeRev}"
        Invoke-Expression "svn co ${url}@${beforeRev} $beforeDir"
    }
}

function U-Create-DiffList() {
    Write-Verbose "Xg쐬Jn ${url}@${beforeRev}:${afterRev}"
    
    if ($beforeRev -eq $null) {
        # ŐV\[X̂ݎw肳ꂽꍇ
        Invoke-Expression "svn list --recursive -r $afterRev $url" |
            Set-Content -Encoding String $listPath
    } else {
        # ύXO/\[Xw肳ꂽꍇ
        Invoke-Expression "svn diff -r ${beforeRev}:${afterRev} --summarize ${url}" | %{
            if ($_ -match "^(.+) +(.+)$") {
                $encodedUrl = $matches[2]
                $decodedUrl = [System.Uri]::UnescapeDataString($encodedUrl)
                if ($decodedUrl -match "${url}/(.+)$") {
                    Write-Output $matches[1]
                } elseif ($decodedUrl -match "${url}$") {
                    # o͕sv
                } else {
                    Write-Output "# Warning ͎s $_"
                    Write-Warning "Warning ͎s $_"
                }
            } else {
                Write-Output "# Warning ͎s $_"
                Write-Warning "Warning ͎s $_"
            }
        } | Set-Content -Encoding String $listPath
    }
}

######################################################################
### s
######################################################################

###
### O
###

$baseDir = Convert-Path $(Split-Path $MyInvocation.InvocationName -Parent)
$psName = Split-Path $MyInvocation.InvocationName -Leaf
$psBaseName = $psName -replace "\.ps1$", ""
$listPath = "${outDir}\DiffList.txt"
Write-Debug "$psName Start"

###
### 又
###

if ($outDir -eq $null) {
    U-Write-Usage
} else {
    U-Run-Main
}

###
### ㏈
###

Write-Debug "$psName End"
