## Active Perl 5.8.8
# 注意>DBD-mysql を 4.005 以上にアップデートしてください。
# 注意>Jcode も必要です。
# 注意>やりかた: ppm install http://theoryx5.uwinnipeg.ca/ppms/DBD-mysql.ppd
# 注意>やりかた: ppm install Jcode

# *.htm 中のスキル名を一括して日本語化する
# mods/NpcBuffer-*.htm 編

use utf8;
use strict;
use warnings;
use Encode;
use DBI;
use Jcode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $vars_txt = 'tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^\@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('build/dist/game/data/html/mods/', 'NpcBuffer-1.htm');
&start('build/dist/game/data/html/mods/', 'NpcBuffer-2.htm');
&start('build/dist/game/data/html/mods/', 'NpcBuffer-3.htm');

close LOG;
exit 0;

sub start {
	my ($subDir, $fileName) = @_;

	my $filePath = $subDir.$fileName;

	my $outPath = $filePath;
	   $outPath .= '.text' if $DEBUG;

	print "  $filePath\n" if $DEBUG;
	open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
	my $mtime = (stat FILE)[9];
	read FILE,my $text,-s FILE;
	close FILE;

	my $original = $text;

	my $UPDATE = 0;
	while ($text =~ m!<a action="bypass -h npc_%objectId%_Buff (\d+)">(.+?)</a>!g) {
		# <a action="bypass -h npc_%objectId%_Buff 530">Dance of Alignment</a>
		my $id = $1;
		my $name_en = $2;

		my $name_jp = &getName($id);
		next unless $name_jp;
		next if $name_jp eq $name_en;

		$text =~ s!(?<=<a action="bypass -h npc_%objectId%_Buff $id">).+?(?=</a>)!$name_jp!;

		my $i = &minidiff($text, $original) unless $UPDATE;
		print  '+',$outPath,"(",$i,")\n" unless $UPDATE;
		print     "\t[",$name_en,"]\n";
		print     "\t[",$name_jp,"]\n";
		print LOG  $outPath,"(",$i,")\n" unless $UPDATE;
		print LOG "\t[",$name_en,"]\n";
		print LOG "\t[",$name_jp,"]\n";

		$UPDATE = 1;
	}
#	while (....) {
#		# <button action="bypass -h npc_%objectId%_Buff 264 266 268 269 271 274 275 304 310 1036 1040 1045 1062 1068 1077 1086 1240 1242" value="Fighter" width=200 height=21 back="L2UI_ct1.button_df" fore="L2UI_ct1.button_df">
#	}

	if ($UPDATE) {
		open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);
	}
}

sub getName {
	my ($buff_group) = @_;

	my $sql = "SELECT skillname_ja.name,custom_npc_buffer.skill_level FROM custom_npc_buffer
 LEFT JOIN skillname_ja
  ON ( custom_npc_buffer.skill_id   =skillname_ja.id
   AND custom_npc_buffer.skill_level=skillname_ja.level )
 WHERE custom_npc_buffer.buff_group=?";
	my $sth = $db->prepare($sql);
	$sth->execute($buff_group) or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_name,$N_level))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return '' unless $N_name;
	return Encode::decode_utf8(Jcode->new($N_name, 'utf8')->z2h->utf8) . " Lv$N_level"
#	return $N_name;
}

sub minidiff {
	my ($textA, $textB) = @_;

	$textA =~ s/^\x{FEFF}//;
	$textB =~ s/^\x{FEFF}//;
	my @A = split /\n/,$textA;
	my @B = split /\n/,$textB;
	my $min = $#A <= $#B ? $#A : $#B;
	for (my $i=0; $i <=$min; ++$i) {
		return $i+1 if $A[$i] ne $B[$i];
	}
	return 0;
}
