﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT, ':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0;
my @CC;	#@IF DEBUG@#

&start('./');

if (@CC) {
	my $LogFile = UTF8(__FILE__);	#@IF DEBUG@#
	   $LogFile =~ s!\.[^.\/\\]*$!.log!;	#@IF DEBUG@#
	open LOG, '>:utf8', FS($LogFile) or die "'$LogFile' $!";	#@IF DEBUG@#
	my $i = 0; ++$i until $CC[$i];
	for (; $i <= $#CC; ++$i) {	#@IF DEBUG@#
		if ($CC[$i]) {print LOG __FILE__,"($i)\t",$CC[$i],"\n"}	#@IF DEBUG@#
		else         {print LOG __FILE__,"($i)\t",0,"\n"}	#@IF DEBUG@#
	}	#@IF DEBUG@#
	close LOG;	#@IF DEBUG@#
}

exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		next unless $fileName =~ m!\.html?$!;

		my $filePath = $subDir.$fileName;
		open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
		read FILE, my $htm, -s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $htm;
		$_           = $htm;
#----------------------------------------------------------------------------
## 領地管理人 36490,36491,36492,36493,36494,36495,36496,36497,36498 ##

# L2J_DataPack_BETA r9055
s!(?<=<a action="bypass -h Quest TerritoryManagers BuyProducts">).+?(?=</a>)!特産品を買う!;		#Buy special products.
s!(?<=<a action="bypass -h Quest TerritoryManagers 36490-04.html">).+?(?=</a>)!ノーブレスに任命してもらう!; #〓仮〓	#Make me a Noblesse.
s!(?<=<a action="bypass -h Quest TerritoryManagers 36490-03.html">).+?(?=</a>)!バッジのことを聞く!;	#Tell me about badges.
s!(?<=<a action="bypass -h npc_%objectId%_TerritoryStatus">).+?(?=</a>)!領地の状況を聞く!;		#Ask about the fortress's current status.
s!(?<=<a action="bypass -h Quest TerritoryManagers CalcRewards">).+?(?=</a>)!クエスト!;			#Quest
#----------------------------------------------------------------------------

		$htm = $_;

		if ($htm ne $original) {
			print $filePath,"\n";
			my $output = $filePath;
			   $output = $filePath.'.text' if $DEBUG;
			open FILE, '>:utf8', $output  or die "'$output' $!";
			$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,$output;
		}
	}
}
