/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.script.java;

import com.l2jserver.script.java.JavaCompiler;
import com.l2jserver.script.java.JavaScriptEngineFactory;
import com.l2jserver.script.java.MemoryClassLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class JavaScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private final JavaCompiler compiler = new JavaCompiler();
    private ScriptEngineFactory factory;
    private static final String SYSPROP_PREFIX = "com.sun.script.java.";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String ARGUMENTS = "arguments";
    private static final String SOURCEPATH = "sourcepath";
    private static final String CLASSPATH = "classpath";
    private static final String MAINCLASS = "mainClass";
    private static final String PARENTLOADER = "parentLoader";

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(script, this.context);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        Class<?> clazz = this.parse(str, ctx);
        return JavaScriptEngine.evalClass(clazz, ctx);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JavaScriptEngine javaScriptEngine = this;
        synchronized (javaScriptEngine) {
            if (this.factory == null) {
                this.factory = new JavaScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private Class<?> parse(String str, ScriptContext ctx) throws ScriptException {
        Map<String, byte[]> classBytes;
        String fileName = JavaScriptEngine.getFileName(ctx);
        String sourcePath = JavaScriptEngine.getSourcePath(ctx);
        String classPath = JavaScriptEngine.getClassPath(ctx);
        Writer err = ctx.getErrorWriter();
        if (err == null) {
            err = new StringWriter();
        }
        if ((classBytes = this.compiler.compile(fileName, str, err, sourcePath, classPath)) == null) {
            if (err instanceof StringWriter) {
                throw new ScriptException(((StringWriter)err).toString());
            }
            throw new ScriptException("compilation failed");
        }
        MemoryClassLoader loader = new MemoryClassLoader(classBytes, classPath, JavaScriptEngine.getParentLoader(ctx));
        return JavaScriptEngine.parseMain(loader, ctx);
    }

    protected static Class<?> parseMain(MemoryClassLoader loader, ScriptContext ctx) throws ScriptException {
        Iterable<Class<?>> classes;
        String mainClassName = JavaScriptEngine.getMainClassName(ctx);
        if (mainClassName != null) {
            try {
                Class<?> clazz = loader.load(mainClassName);
                Method mainMethod = JavaScriptEngine.findMainMethod(clazz);
                if (mainMethod == null) {
                    throw new ScriptException("no main method in " + mainClassName);
                }
                return clazz;
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
                throw new ScriptException(cnfe);
            }
        }
        try {
            classes = loader.loadAll();
        }
        catch (ClassNotFoundException exp) {
            throw new ScriptException(exp);
        }
        Class<?> c = JavaScriptEngine.findMainClass(classes);
        if (c != null) {
            return c;
        }
        Iterator<Class<?>> itr = classes.iterator();
        if (itr.hasNext()) {
            return itr.next();
        }
        return null;
    }

    private JavaCompiledScript compile(String str, ScriptContext ctx) throws ScriptException {
        Map<String, byte[]> classBytes;
        String fileName = JavaScriptEngine.getFileName(ctx);
        String sourcePath = JavaScriptEngine.getSourcePath(ctx);
        String classPath = JavaScriptEngine.getClassPath(ctx);
        Writer err = ctx.getErrorWriter();
        if (err == null) {
            err = new StringWriter();
        }
        if ((classBytes = this.compiler.compile(fileName, str, err, sourcePath, classPath)) == null) {
            if (err instanceof StringWriter) {
                throw new ScriptException(((StringWriter)err).toString());
            }
            throw new ScriptException("compilation failed");
        }
        return new JavaCompiledScript(this, classBytes, classPath);
    }

    private static Class<?> findMainClass(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            Method mainMethod;
            int modifiers = clazz.getModifiers();
            if (!Modifier.isPublic(modifiers) || (mainMethod = JavaScriptEngine.findMainMethod(clazz)) == null) continue;
            return clazz;
        }
        for (Class<?> clazz : classes) {
            Method mainMethod = JavaScriptEngine.findMainMethod(clazz);
            if (mainMethod == null) continue;
            return clazz;
        }
        return null;
    }

    private static Method findMainMethod(Class<?> clazz) {
        try {
            Method mainMethod = clazz.getMethod("main", String[].class);
            int modifiers = mainMethod.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                return mainMethod;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Method findSetScriptContextMethod(Class<?> clazz) {
        try {
            Method setCtxMethod = clazz.getMethod("setScriptContext", ScriptContext.class);
            int modifiers = setCtxMethod.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                return setCtxMethod;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static String getFileName(ScriptContext ctx) {
        int scope = ctx.getAttributesScope("javax.script.filename");
        if (scope != -1) {
            return ctx.getAttribute("javax.script.filename", scope).toString();
        }
        return "$unnamed.java";
    }

    private static String[] getArguments(ScriptContext ctx) {
        Object obj;
        int scope = ctx.getAttributesScope(ARGUMENTS);
        if (scope != -1 && (obj = ctx.getAttribute(ARGUMENTS, scope)) instanceof String[]) {
            return (String[])obj;
        }
        return EMPTY_STRING_ARRAY;
    }

    private static String getSourcePath(ScriptContext ctx) {
        int scope = ctx.getAttributesScope(SOURCEPATH);
        if (scope != -1) {
            return ctx.getAttribute(SOURCEPATH).toString();
        }
        return System.getProperty("com.sun.script.java.sourcepath");
    }

    private static String getClassPath(ScriptContext ctx) {
        int scope = ctx.getAttributesScope(CLASSPATH);
        if (scope != -1) {
            return ctx.getAttribute(CLASSPATH).toString();
        }
        String res = System.getProperty("com.sun.script.java.classpath");
        if (res == null) {
            res = System.getProperty("java.class.path");
        }
        return res;
    }

    private static String getMainClassName(ScriptContext ctx) {
        int scope = ctx.getAttributesScope(MAINCLASS);
        if (scope != -1) {
            return ctx.getAttribute(MAINCLASS).toString();
        }
        return System.getProperty("com.sun.script.java.mainClass");
    }

    protected static ClassLoader getParentLoader(ScriptContext ctx) {
        Object loader;
        int scope = ctx.getAttributesScope(PARENTLOADER);
        if (scope != -1 && (loader = ctx.getAttribute(PARENTLOADER)) instanceof ClassLoader) {
            return (ClassLoader)loader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    protected static Object evalClass(Class<?> clazz, ScriptContext ctx) throws ScriptException {
        ctx.setAttribute("context", ctx, 100);
        if (clazz == null) {
            return null;
        }
        try {
            Method mainMethod;
            boolean isPublicClazz = Modifier.isPublic(clazz.getModifiers());
            Method setCtxMethod = JavaScriptEngine.findSetScriptContextMethod(clazz);
            if (setCtxMethod != null) {
                if (!isPublicClazz) {
                    setCtxMethod.setAccessible(true);
                }
                setCtxMethod.invoke(null, ctx);
            }
            if ((mainMethod = JavaScriptEngine.findMainMethod(clazz)) != null) {
                if (!isPublicClazz) {
                    mainMethod.setAccessible(true);
                }
                String[] args = JavaScriptEngine.getArguments(ctx);
                mainMethod.invoke(null, new Object[]{args});
            }
            return clazz;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw new ScriptException(exp);
        }
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    private static class JavaCompiledScript
    extends CompiledScript
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final transient JavaScriptEngine _engine;
        private transient Class<?> _class;
        private final Map<String, byte[]> _classBytes;
        private final String _classPath;

        JavaCompiledScript(JavaScriptEngine engine, Map<String, byte[]> classBytes, String classPath) {
            this._engine = engine;
            this._classBytes = classBytes;
            this._classPath = classPath;
        }

        @Override
        public ScriptEngine getEngine() {
            return this._engine;
        }

        @Override
        public Object eval(ScriptContext ctx) throws ScriptException {
            if (this._class == null) {
                HashMap<String, byte[]> classBytesCopy = new HashMap<String, byte[]>();
                classBytesCopy.putAll(this._classBytes);
                MemoryClassLoader loader = new MemoryClassLoader(classBytesCopy, this._classPath, JavaScriptEngine.getParentLoader(ctx));
                this._class = JavaScriptEngine.parseMain(loader, ctx);
            }
            return JavaScriptEngine.evalClass(this._class, ctx);
        }
    }
}

