/*
 * Decompiled with CFR 0.152.
 */
package javatests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javatests.TestSupport;

public abstract class ListTest {
    private final List nullList = this.newInstance(Arrays.asList(new Object[]{null}));

    public static ListTest getArrayListTest(final boolean bl) {
        return new ListTest(){

            public List newInstance(Collection collection) {
                ArrayList arrayList = null;
                arrayList = collection == null ? new ArrayList() : new ArrayList(collection);
                return bl ? Collections.unmodifiableList(arrayList) : arrayList;
            }

            public boolean isReadOnly() {
                return bl;
            }
        };
    }

    public static void verifyImutability(List list) {
        String string = "Expected UnsupportedOperationException.";
        try {
            list.add(0, new Integer(0));
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.add(new Integer(0));
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.addAll(null);
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.addAll(0, null);
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.clear();
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.remove(0);
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.remove(new Object());
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.removeAll(null);
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.retainAll(null);
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.set(0, new Integer(0));
            TestSupport.assertThat(false, string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected List defaultList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            arrayList.add(new Integer(i));
        }
        return this.newInstance(arrayList);
    }

    public List newInstance(Collection collection) {
        throw new UnsupportedOperationException("This method must be overridden");
    }

    public boolean isReadOnly() {
        throw new UnsupportedOperationException("This method must be overridden");
    }

    public void testAll() {
        this.test_get();
        this.test_equals();
        this.test_size();
        this.test_contains();
        this.test_containsAll();
        try {
            ((Object)this.defaultList()).hashCode();
            this.test_hashCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.test_subList();
        this.test_lastIndexOf();
        this.test_listIterator();
        this.test_toArray();
        this.test_toArray_typed();
        if (!this.isReadOnly()) {
            this.test_add();
            this.test_add_index();
            this.test_set();
            this.test_clear();
            this.test_addAll();
            this.test_addAll_index();
            this.test_remove();
            this.test_remove_index();
            this.test_removeAll();
            this.test_retainAll();
        } else {
            ListTest.verifyImutability(this.newInstance(null));
        }
    }

    public void test_get() {
        TestSupport.assertThat(this.defaultList().get(0).equals(new Integer(0)), "get() did not return expected value of Integer(0)");
        try {
            this.defaultList().get(-1);
            TestSupport.assertThat(false, "get(<negative index>) did not throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.defaultList().get(-1);
            TestSupport.assertThat(false, "get(<index too big>) did not throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_set() {
        try {
            this.newInstance(null).set(-1, "spam");
            TestSupport.assertThat(false, "get(<negative index>) did not throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.newInstance(null).set(0, "spam");
            TestSupport.assertThat(false, "set(<index too big>) did not throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        List list = this.defaultList();
        list.set(list.size() - 1, "spam");
        TestSupport.assertThat(list.get(list.size() - 1).equals("spam"), "set() object was not retrieved via get()");
    }

    public void test_add() {
        List list = this.newInstance(null);
        for (int i = 0; i < 4; ++i) {
            list.add(new Integer(i));
        }
        TestSupport.assertEquals(list, this.defaultList(), "add(Object o) failed");
    }

    public void test_isEmpty() {
        List list = this.newInstance(null);
        TestSupport.assertThat(list.isEmpty(), "isEmpty() is false on an emtpy List");
        list.addAll(this.defaultList());
        TestSupport.assertThat(!list.isEmpty(), "isEmpty() is true on a non-empty List)");
        list.clear();
        TestSupport.assertThat(list.isEmpty(), "isEmpty() is false on an emtpy List");
    }

    public void test_size() {
        List list = this.newInstance(null);
        TestSupport.assertThat(list.size() == 0, "empty list size was not 0");
        TestSupport.assertThat(this.defaultList().size() == 4, "default list did not have a size of 4");
    }

    public void test_add_index() {
        List list = this.newInstance(null);
        List list2 = this.defaultList();
        for (int i = 0; i < list2.size(); ++i) {
            list.add(i, list2.get(i));
        }
        try {
            list.add(list.size() + 1, new Integer(list.size() + 1));
            TestSupport.assertThat(false, "expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.add(-1, new Integer(-1));
            TestSupport.assertThat(false, "expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_equals() {
        TestSupport.assertEquals(this.defaultList(), this.defaultList(), "Identical lists weren't equal()");
        TestSupport.assertNotEquals(this.newInstance(null), this.defaultList(), "Different lists were equal()");
        TestSupport.assertNotEquals(this.newInstance(null), new Object(), "List was equal to a non-List type");
    }

    public void test_addAll() {
        List list;
        List list2 = this.defaultList();
        TestSupport.assertThat(list2.addAll(list = this.defaultList()), "Mutating addAll(Collection) returned false");
        TestSupport.assertThat(!list2.addAll(this.newInstance(null)), "Idempotent addAll(Collection) returned true");
        TestSupport.assertThat(list.addAll(list), "Mutating addAll(Collection) returned false");
        TestSupport.assertEquals(list2, list, "Expected equal objects from addAll(collection)");
        TestSupport.assertThat(list2.size() == 8, "Expected List to have size 8 after addAll(Collection)");
    }

    public void indexOf() {
        TestSupport.assertThat(this.defaultList().indexOf(new Integer(3)) == 3, "indexOf(3) did not return 3");
        TestSupport.assertThat(this.defaultList().indexOf(new Integer(42)) == -1, "indexOf() non-existing entry did not return -1");
        TestSupport.assertThat(this.defaultList().indexOf(null) == -1, "indexOf() non-existing null did not return -1");
    }

    public void test_contains() {
        TestSupport.assertThat(!this.defaultList().contains(new Integer(42)), "contains() returned true for non-existing entry");
        TestSupport.assertThat(this.defaultList().contains(new Integer(0)), "contains() returned false for existing entry");
        TestSupport.assertThat(this.nullList.contains(null), "contains() returned false for existing null entry");
        TestSupport.assertThat(!this.defaultList().contains(null), "contains() returned true for non-existing null entry");
    }

    public void test_remove() {
        List list = this.defaultList();
        list.add(null);
        TestSupport.assertThat(list.remove(null), "remove() existing null entry returned false");
        TestSupport.assertThat(!list.remove(null), "remove() non-existing null entry returned false");
        list.add("spam");
        TestSupport.assertThat(list.remove("spam"), "remove() existing entry returned false");
        TestSupport.assertThat(!list.remove("spam"), "remove() non-existing entry returned true");
    }

    public void test_remove_index() {
        List list = this.defaultList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.remove(0);
        }
        TestSupport.assertThat(list.size() == 0, "remove()-d all entries but size() not 0");
        try {
            list.remove(0);
            TestSupport.assertThat(false, "removing a non-existing index did not throw exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_lastIndexOf() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.defaultList());
        arrayList.add(new Integer(0));
        List list = this.newInstance(arrayList);
        TestSupport.assertThat(list.lastIndexOf(new Integer(0)) == 4, "lastIndexOf() did not return 4");
        TestSupport.assertThat(list.lastIndexOf(new Integer(42)) == -1, "lastIndexOf() non-existing value did not return -1");
    }

    public void test_removeAll() {
        List list = this.defaultList();
        TestSupport.assertThat(list.removeAll(list), "mutating removeAll() did not return true");
        TestSupport.assertThat(!list.removeAll(list), "idempotent removeAll did not return false");
        TestSupport.assertThat(!list.removeAll(this.nullList), "idempotent removeAll did not return false");
        List list2 = this.newInstance(null);
        list2.addAll(this.nullList);
        TestSupport.assertThat(list2.removeAll(this.nullList), "mutating removeAll() did not return true");
        TestSupport.assertThat(list2.size() == 0, "empty list had non-zero size");
        TestSupport.assertThat(!list2.removeAll(this.newInstance(null)), "idempotent removeAll did not return false");
    }

    public void test_addAll_index() {
        List list = this.defaultList();
        List list2 = this.newInstance(null);
        TestSupport.assertThat(list2.addAll(0, list), "mutating addAll(index, Collection) did not return true");
        TestSupport.assertEquals(list, list2, "addAll(index, Collection) instances failed equals test");
        TestSupport.assertThat(!list.addAll(0, this.newInstance(null)), "idempotent addAll(index, Collection) did not return false");
        TestSupport.assertThat(list2.addAll(0, list2), "mutating addAll(index, Collection) did not return true");
        list2 = this.newInstance(null);
        list2.addAll(new ArrayList(this.defaultList()));
        TestSupport.assertEquals(this.defaultList(), list2, "addAll(index, <ArrayList>) failed equals test");
    }

    public void test_hashCode() {
        List list = this.defaultList();
        TestSupport.assertThat(((Object)list).hashCode() == ((Object)this.defaultList()).hashCode(), "Instances with same internal state have different hashcode");
        TestSupport.assertThat(((Object)list).hashCode() != ((Object)this.newInstance(null)).hashCode(), "Instances with different internal state have the same hashcode");
        if (!this.isReadOnly()) {
            List list2 = this.newInstance(null);
            list2.addAll(list);
            list2.remove(0);
            TestSupport.assertThat(((Object)list).hashCode() != ((Object)list2).hashCode(), "Instances with different internal state have the same hashcode");
        }
    }

    public void test_clear() {
        List list = this.defaultList();
        list.clear();
        TestSupport.assertThat(list.size() == 0, "clear()-ed list did not have size of 0");
    }

    public void test_subList() {
        List list;
        List list2 = this.defaultList();
        TestSupport.assertThat(list2.subList(0, list2.size()) != list2, "subList() returned the same instance");
        TestSupport.assertEquals(list2.subList(0, list2.size()), list2, "Complete subList() did not equal original List");
        TestSupport.assertThat(list2.subList(0, 0).size() == 0, "empty subList had non-zero size");
        try {
            list2.subList(-1, 1);
            TestSupport.assertThat(false, "Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list2.subList(1, 0);
            TestSupport.assertThat(false, "Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            list2.subList(0, list2.size() + 1);
            TestSupport.assertThat(false, "Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (!this.isReadOnly()) {
            list2.subList(0, list2.size()).clear();
            TestSupport.assertThat(list2.size() == 0, "clear()-ed sublist did not have zero size");
            list = this.newInstance(null);
            list.addAll(this.defaultList());
            List<String> list3 = list.subList(1, 3);
            TestSupport.assertThat(list3.size() == 2, "Expected subList to have size of 2");
            TestSupport.assertThat(list.set(1, "canned").equals(new Integer(1)), "subList.set() did not return Integer(1) from index 1 of defaultList");
            TestSupport.assertThat(list3.get(0).equals("canned"), "subList does not update with changes to parent");
            list3.set(0, "spam");
            TestSupport.assertThat(list.get(1).equals("spam"), "parent does not update with changes to subList child");
        } else {
            list = list2.subList(0, list2.size());
            ListTest.verifyImutability(list);
        }
    }

    public void test_retainAll() {
        List list = this.defaultList();
        list.retainAll(this.defaultList());
        TestSupport.assertEquals(list, this.defaultList(), "retainAll(<equal List>) does not equal original list");
        list = this.defaultList();
        list.retainAll(this.newInstance(null));
        TestSupport.assertThat(list.size() == 0, "retainAll(<empty List>))does not have size of zero");
        list = this.defaultList();
        list.remove(0);
        list.remove(0);
        list.add(new Integer(4));
        list.add(new Integer(5));
        List list2 = this.newInstance(null);
        list2.add(new Integer(2));
        list2.add(new Integer(3));
        list.retainAll(list2);
        TestSupport.assertEquals(list, list2, "retainAll() on overlap of indices [2,3] did not return that List");
    }

    public void test_containsAll() {
        TestSupport.assertThat(this.defaultList().containsAll(this.defaultList()), "containsAll(<identical List> was false");
        TestSupport.assertThat(this.defaultList().containsAll(this.newInstance(null)), "containsAll(<empty List>) was false");
        TestSupport.assertThat(!this.newInstance(null).containsAll(this.defaultList()), "containsAll(<disjoint List>) returned true");
        TestSupport.assertThat(this.defaultList().containsAll(this.defaultList().subList(1, 3)), "containsAll(<subList>) was false");
    }

    public void test_iterator() {
        TestSupport.assertThat(!this.newInstance(null).iterator().hasNext(), "Iterator for empty list thinks it hasNext()");
        try {
            this.newInstance(null).iterator().next();
            TestSupport.assertThat(false, "expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        List list = this.defaultList();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TestSupport.assertThat(iterator.next() == list.get(n++), "Iterator next() failed identity test");
        }
        TestSupport.assertThat(n == list.size(), "Iterator did not iterator over entire list");
    }

    public void test_listIterator() {
        ListIterator<Integer> listIterator = this.newInstance(null).listIterator();
        TestSupport.assertThat(!listIterator.hasNext(), "ListIterator.hasNext() is true for empty List");
        TestSupport.assertThat(!listIterator.hasPrevious(), "ListIterator.hasPrevious() is true for empty List");
        try {
            listIterator.next();
            TestSupport.assertThat(false, "expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            listIterator.previous();
            TestSupport.assertThat(false, "expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        int n = listIterator.nextIndex();
        TestSupport.assertThat(n == -1 || n == 0, "ListIterator.nextIndex() on empty List did not return 0 (java 1.4) or did not return -1 (java 1.3)");
        int n2 = listIterator.previousIndex();
        TestSupport.assertThat(n2 == -1 || n2 == -2, "ListIterator.previousIndex() on empty List did not return -1 (java 1.4) or -2 (java 1.3)");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(1));
        listIterator = this.newInstance(arrayList).listIterator();
        TestSupport.assertThat(!listIterator.hasPrevious(), "ListIterator.hasPrevious() is true with nothing previous");
        TestSupport.assertThat(listIterator.hasNext(), "ListIterator.hasNext() is false with next present");
        TestSupport.assertThat(listIterator.next().equals(new Integer(1)), "ListIterator.next() did not return expected Integer(1)");
        if (!this.isReadOnly()) {
            listIterator.remove();
            TestSupport.assertThat(!listIterator.hasNext(), "ListIterator.hasNext() is true for empty List");
            TestSupport.assertThat(!listIterator.hasPrevious(), "ListIterator.hasPrevious() is true for empty List");
            try {
                listIterator.set(new Integer(42));
                TestSupport.assertThat(false, "expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                listIterator.remove();
                TestSupport.assertThat(false, "expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        arrayList = new ArrayList();
        arrayList.add(new Integer(0));
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        listIterator = this.newInstance(arrayList).listIterator();
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            TestSupport.assertThat(listIterator.next().equals(new Integer(i)), "ListIterator.previous did not return expected value");
        }
        while (!this.isReadOnly() && listIterator.hasNext()) {
            listIterator.next();
            listIterator.set(new Integer(42));
            TestSupport.assertThat(listIterator.previous().equals(new Integer(42)), "ListIterator.previous() did not return the value that was set()");
            listIterator.remove();
        }
        if (this.isReadOnly()) {
            listIterator = this.newInstance(null).listIterator();
        }
        listIterator = this.defaultList().listIterator(2);
        TestSupport.assertThat(listIterator.next().equals(new Integer(2)), "List.listIteraor(index) did not return expected value");
        TestSupport.assertThat(listIterator.next().equals(new Integer(3)), "List.listIteraor(index) did not return expected value");
        TestSupport.assertThat(!listIterator.hasNext(), "listIterator.hasNext() at end of list returned true");
    }

    public void test_toArray() {
        Object[] objectArray = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
        TestSupport.assertThat(Arrays.equals(this.defaultList().toArray(), objectArray), "toArray() did not return the expected Integer[] array");
    }

    public void test_toArray_typed() {
        Object[] objectArray = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
        TestSupport.assertThat(Arrays.equals((Object[])this.defaultList().toArray(new Integer[0]), objectArray), "toArray(Integer[]) did not return the expected Integer[] array");
    }
}

