## Active Perl 5.8.8 or later

# Add comments to MapRegion.xml
# Author JOJO

use utf8;
use strict;
use warnings;
use Encode;
use DBI;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $systemmsg_txt = '../lang/ja/systemmsg.txt';

my $DEBUG = 0; # 1 or 0

my $vars_txt = '../../../../tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

my %castlename = ();
my %systemmsg = ();
&loadCastleNameAll();
&loadSystemMsgAll();

opendir DIR, '.'  or die $!;
my @files = grep m/\.xml$/, map {UTF8($_)} readdir DIR;
closedir DIR;

&start($_) for @files;

exit 0;

sub start {
	my ($filePath) = @_;

	print "$filePath\n" if $DEBUG;
	open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
	my $mtime = (stat FILE)[9];
	read FILE,my $text,-s FILE;
	close FILE;

	my $backup = $text;
	my @T = split m/(?<=[\n])/, $text;
	for (my $i = 0; $i <= $#T; ++$i) {
		my $line = $T[$i];
		if ($line =~ m/<region .* castle="(\d+)" locId="(\d+)"/) {
			my $castle = $1;
			my $locId = $2;

			my $castleName = $castlename{$castle};
			my $locMsg = $systemmsg{$locId};
			my $town;
			if ($locMsg =~ m/^現在地： ?\$s1/) {
				if ($locMsg =~ m/\((.+?)\)$/) { #'現在地： $s1、$s2、$s3 (中立地帯付近)'
					$town = $1;
				}
				elsif ($locMsg =~ m/（(.+?)）$/) { #'現在地： $s1, $s2, $s3（クセルス同盟の連合基地のそば）'
					$town = $1;
				}
			} else {
				if ($locMsg !~ m/\$s1/ && $locMsg =~ m/^現在地： ?(.+)$/) { #'現在地：カマロカ内部'
					$town = $1;
				}
			}
			unless ($town) { print "'$locMsg' - "; die }

			my $j;
			if ($T[$i - 1] =~ m/^\t<!--.*-->$/) { $j = $i - 1 }
			else { $j = $i }

			$T[$j] =~ s/ *<!--".*//;
			if ($castleName) {$T[$j] =~ s/$/ <!--"$castleName","$locMsg"-->/}
			else             {$T[$j] =~ s/$/ <!--"$locMsg"-->/}

			$T[$i] =~ s/(?<=\btown=")(.+?)(?=")/$town/;

			print "\t$castleName,$locMsg\n" if $DEBUG;
		}
	}
	$text = join '',@T;

	if ($backup ne $text) {
		my $outPath = $filePath;
		   $outPath = $filePath . '.text' if $DEBUG;
		open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);
	}
}

sub loadSystemMsgAll {
	open FILE,'<:utf8',FS($systemmsg_txt)  or do {warn "'$systemmsg_txt' $!";exit 0};
	while (not eof FILE) {
		my $line = <FILE>;
		next if $line =~ m!^/!;
		chomp $line;
		my ($N_id, $N_name) = split /\t/, $line;
		$systemmsg{$N_id} = $N_name
	}
	close FILE;
}

sub loadCastleNameAll {
	my $sth = $db->prepare("SELECT id,name FROM castlename_ja");
	$sth->execute or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_id,$N_name))) or die DBI::errstr;

	while (my $rc = $sth->fetch()) {
		$castlename{$N_id} = $N_name;
	}
}
