/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.voicedcommandhandlers;

import com.l2jserver.gameserver.handler.IVoicedCommandHandler;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;

/**
 * @author JOJO
 * http://www.l2jserver.com/forum/viewtopic.php?f=69&t=17801
 */
public class ExpSwitch implements IVoicedCommandHandler
{
	private static final String[] _voicedCommands = { "exp" };
	
	/**
	 * 
	 * @see com.l2jserver.gameserver.handler.IVoicedCommandHandler#useVoicedCommand(java.lang.String, com.l2jserver.gameserver.model.actor.instance.L2PcInstance, java.lang.String)
	 */
	@Override
	public boolean useVoicedCommand(String command, L2PcInstance activeChar, String target)
	{
		if (target == null)
		{
			activeChar.sendMessage("Usage: .exp [on|off]");
			return false;
		}
		else if (target.equals("on"))
		{
			activeChar.setExpGainOn(true);
			activeChar.sendMessage("Gain Exp and SP on!");
		}
		else if (target.equals("off"))
		{
			activeChar.setExpGainOn(false);
			activeChar.sendMessage("Gain Exp and SP off!");
		}
		else
		{
			activeChar.sendMessage("Usage: .exp [on|off]");
			return false;
		}
		return true;
	}
	
	/**
	 * 
	 * @see com.l2jserver.gameserver.handler.IVoicedCommandHandler#getVoicedCommandList()
	 */
	@Override
	public String[] getVoicedCommandList()
	{
		return _voicedCommands;
	}
}