/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;
import javolution.util.FastTable;

final class PerfUtil
extends Javolution
implements Runnable {
    private static final int MAX_COLLECTION_SIZE = 10000;
    private static final int ITERATIONS = 100;
    private final Object[] _objects = new Object[10000];

    PerfUtil() {
    }

    public void run() throws JavolutionError {
        this.println("//////////////////////////////");
        this.println("// Package: javolution.util //");
        this.println("//////////////////////////////");
        this.println("");
        this.println("(new)      : The collection is created (using the new keyword), populated, then discarded (throw-away collections).");
        this.println("(recycled) : The collection is cleared, populated, then reused (static collections or throw-away collections in PoolContext).");
        this.println("");
        for (int i = 0; i < 10000; ++i) {
            this._objects[i] = new Object();
        }
        this.println("-- FastTable versus ArrayList -- ");
        this.benchmarkFastTable();
        this.benchmarkArrayList();
        this.println("-- FastList versus LinkedList -- ");
        this.benchmarkFastList();
        this.benchmarkLinkedList();
        this.println("");
        this.println("-- FastMap versus HashMap  --");
        this.benchmarkFastMap();
        this.benchmarkHashMap();
        this.benchmarkLinkedHashMap();
        this.println("");
        this.println("-- FastMap.setShared(true) versus ConcurrentHashMap  --");
        this.benchmarkSharedFastMap();
        this.benchmarkConcurrentHashMap();
        this.println("");
        this.println("-- FastSet versus HashSet --");
        this.benchmarkFastSet();
        this.benchmarkHashSet();
        this.benchmarkLinkedHashSet();
        this.println("");
    }

    private void benchmarkFastTable() {
        FastTable<Object> fastTable = new FastTable<Object>();
        this.println(fastTable.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", add (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastTable = new FastTable();
                    n = 0;
                    while (n < i) {
                        fastTable.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", add (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastTable.clear();
                    n = 0;
                    while (n < i) {
                        fastTable.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = fastTable.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != fastTable) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            if (fastTable instanceof RandomAccess) {
                this.print(", get(int): ");
                for (n3 = 0; n3 < 100; ++n3) {
                    this.startTime();
                    for (n2 = 0; n2 < n4; ++n2) {
                        int n5 = fastTable.size();
                        while (--n5 > 0) {
                            if (fastTable.get(n5) != fastTable) continue;
                            throw new Error();
                        }
                    }
                    this.keepBestTime(i * n4);
                }
                this.print(this.endTime());
            }
            this.println("");
        }
        this.println("");
    }

    private void benchmarkFastList() {
        FastList<Object> fastList = new FastList<Object>();
        this.println(fastList.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", add (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastList = new FastList();
                    n = 0;
                    while (n < i) {
                        fastList.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", add (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastList.clear();
                    n = 0;
                    while (n < i) {
                        fastList.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = fastList.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != fastList) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (node): ");
            FastList<Object> fastList2 = fastList;
            for (n2 = 0; n2 < 100; ++n2) {
                this.startTime();
                for (int j = 0; j < n4; ++j) {
                    FastCollection.Record record = fastList2.head();
                    FastCollection.Record record2 = fastList2.tail();
                    while ((record = ((FastList.Node)record).getNext()) != record2) {
                        if (((FastList.Node)record).getValue() != fastList) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            if (fastList instanceof RandomAccess) {
                this.print(", get(int): ");
                for (n2 = 0; n2 < 100; ++n2) {
                    this.startTime();
                    for (int j = 0; j < n4; ++j) {
                        int n5 = fastList.size();
                        while (--n5 > 0) {
                            if (fastList.get(n5) != fastList) continue;
                            throw new Error();
                        }
                    }
                    this.keepBestTime(i * n4);
                }
                this.print(this.endTime());
            }
            this.println("");
        }
        this.println("");
    }

    private void benchmarkArrayList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!arrayList.getClass().getName().equals("java.util.ArrayList")) {
            return;
        }
        this.println(arrayList.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", add (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    arrayList = new ArrayList();
                    n = 0;
                    while (n < i) {
                        arrayList.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", add (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    arrayList.clear();
                    n = 0;
                    while (n < i) {
                        arrayList.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != arrayList) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            if (arrayList instanceof RandomAccess) {
                this.print(", get(int): ");
                for (n3 = 0; n3 < 100; ++n3) {
                    this.startTime();
                    for (n2 = 0; n2 < n4; ++n2) {
                        int n5 = arrayList.size();
                        while (--n5 > 0) {
                            if (arrayList.get(n5) != arrayList) continue;
                            throw new Error();
                        }
                    }
                    this.keepBestTime(i * n4);
                }
                this.print(this.endTime());
            }
            this.println("");
        }
        this.println("");
    }

    private void benchmarkLinkedList() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (!linkedList.getClass().getName().equals("java.util.LinkedList")) {
            return;
        }
        this.println(linkedList.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", add (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    linkedList = new LinkedList();
                    n = 0;
                    while (n < i) {
                        linkedList.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", add (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    linkedList.clear();
                    n = 0;
                    while (n < i) {
                        linkedList.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != linkedList) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            if (linkedList instanceof RandomAccess) {
                this.print(", get(int): ");
                for (n3 = 0; n3 < 100; ++n3) {
                    this.startTime();
                    for (n2 = 0; n2 < n4; ++n2) {
                        int n5 = linkedList.size();
                        while (--n5 > 0) {
                            if (linkedList.get(n5) != linkedList) continue;
                            throw new Error();
                        }
                    }
                    this.keepBestTime(i * n4);
                }
                this.print(this.endTime());
            }
            this.println("");
        }
        this.println("");
    }

    private void benchmarkFastMap() {
        FastMap<Object, String> fastMap = new FastMap<Object, String>();
        this.println(fastMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", put (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastMap = new FastMap();
                    n = 0;
                    while (n < i) {
                        fastMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", put (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastMap.clear();
                    n = 0;
                    while (n < i) {
                        fastMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", get: ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    n = 0;
                    while (n < i) {
                        if (fastMap.get(this._objects[n++]) == "") continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = fastMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != fastMap) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (entry): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    FastCollection.Record record = fastMap.head();
                    FastMap.Entry entry = fastMap.tail();
                    while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                        if (((FastMap.Entry)record).getValue() != fastMap) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.println("");
        }
        this.println("");
    }

    private void benchmarkHashMap() {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        if (!hashMap.getClass().getName().equals("java.util.HashMap")) {
            return;
        }
        this.println(hashMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", put (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    hashMap = new HashMap();
                    n = 0;
                    while (n < i) {
                        hashMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", put (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    hashMap.clear();
                    n = 0;
                    while (n < i) {
                        hashMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", get: ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    n = 0;
                    while (n < i) {
                        if (hashMap.get(this._objects[n++]) == "") continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = hashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != hashMap) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.println("");
        }
        this.println("");
    }

    private void benchmarkSharedFastMap() {
        FastMap<Object, String> fastMap = new FastMap().setShared(true);
        this.println("Shared FastMap");
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", put (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastMap = new FastMap().setShared(true);
                    n = 0;
                    while (n < i) {
                        fastMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", put (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastMap.clear();
                    n = 0;
                    while (n < i) {
                        fastMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", get: ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    n = 0;
                    while (n < i) {
                        if (fastMap.get(this._objects[n++]) == "") continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = fastMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != fastMap) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (entry): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    FastCollection.Record record = fastMap.head();
                    FastMap.Entry entry = fastMap.tail();
                    while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                        if (((FastMap.Entry)record).getValue() != fastMap) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.println("");
        }
        this.println("");
    }

    private void benchmarkConcurrentHashMap() {
        ConcurrentHashMap<Object, String> concurrentHashMap = new ConcurrentHashMap<Object, String>();
        this.println(concurrentHashMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", put (new): ");
            for (n3 = 0; n3 < 10; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    concurrentHashMap = new ConcurrentHashMap();
                    n = 0;
                    while (n < i) {
                        concurrentHashMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", put (recycled): ");
            for (n3 = 0; n3 < 10; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    concurrentHashMap.clear();
                    n = 0;
                    while (n < i) {
                        concurrentHashMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", get: ");
            for (n3 = 0; n3 < 10; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    n = 0;
                    while (n < i) {
                        if (concurrentHashMap.get(this._objects[n++]) == "") continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 10; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = concurrentHashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != concurrentHashMap) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.println("");
        }
        this.println("");
    }

    private void benchmarkLinkedHashMap() {
        LinkedHashMap<Object, String> linkedHashMap = new LinkedHashMap<Object, String>();
        if (!linkedHashMap.getClass().getName().equals("java.util.LinkedHashMap")) {
            return;
        }
        this.println(linkedHashMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", put (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    linkedHashMap = new LinkedHashMap();
                    n = 0;
                    while (n < i) {
                        linkedHashMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", put (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    linkedHashMap.clear();
                    n = 0;
                    while (n < i) {
                        linkedHashMap.put(this._objects[n++], "");
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", get: ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    n = 0;
                    while (n < i) {
                        if (linkedHashMap.get(this._objects[n++]) == "") continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = linkedHashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != linkedHashMap) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.println("");
        }
        this.println("");
    }

    private void benchmarkFastSet() {
        FastSet<Object> fastSet = new FastSet<Object>();
        this.println(fastSet.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", add (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastSet = new FastSet();
                    n = 0;
                    while (n < i) {
                        fastSet.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", add (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    fastSet.clear();
                    n = 0;
                    while (n < i) {
                        fastSet.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", contain: ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    n = 0;
                    while (n < i) {
                        if (fastSet.contains(this._objects[n++])) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = fastSet.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != fastSet) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (record): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    FastCollection.Record record = fastSet.head();
                    FastCollection.Record record2 = fastSet.tail();
                    while ((record = record.getNext()) != record2) {
                        if (fastSet.valueOf(record) != fastSet) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.println("");
        }
        this.println("");
    }

    private void benchmarkHashSet() {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (!hashSet.getClass().getName().equals("java.util.HashSet")) {
            return;
        }
        this.println(hashSet.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", add (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    hashSet = new HashSet();
                    n = 0;
                    while (n < i) {
                        hashSet.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", add (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    hashSet.clear();
                    n = 0;
                    while (n < i) {
                        hashSet.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", contain: ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    n = 0;
                    while (n < i) {
                        if (hashSet.contains(this._objects[n++])) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != hashSet) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.println("");
        }
        this.println("");
    }

    private void benchmarkLinkedHashSet() {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (!linkedHashSet.getClass().getName().equals("java.util.LinkedHashSet")) {
            return;
        }
        this.println(linkedHashSet.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3;
            int n4 = 100000 / i;
            this.print("    Size: " + i);
            this.print(", add (new): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    linkedHashSet = new LinkedHashSet();
                    n = 0;
                    while (n < i) {
                        linkedHashSet.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", add (recycled): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    linkedHashSet.clear();
                    n = 0;
                    while (n < i) {
                        linkedHashSet.add(this._objects[n++]);
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", contain: ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    n = 0;
                    while (n < i) {
                        if (linkedHashSet.contains(this._objects[n++])) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.print(", iteration (iterator): ");
            for (n3 = 0; n3 < 100; ++n3) {
                this.startTime();
                for (n2 = 0; n2 < n4; ++n2) {
                    Iterator iterator = linkedHashSet.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != linkedHashSet) continue;
                        throw new Error();
                    }
                }
                this.keepBestTime(i * n4);
            }
            this.print(this.endTime());
            this.println("");
        }
        this.println("");
    }
}

