/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.context.RealtimeObject;
import javolution.io.UTF8ByteBufferReader;
import javolution.io.UTF8ByteBufferWriter;
import javolution.lang.MathLib;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.util.FastComparator;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;
import javolution.util.FastTable;
import javolution.util.Index;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;

final class PerfXML
extends Javolution
implements Runnable {
    private static final int ITERATIONS = 1000;
    private static final int OBJECT_SIZE = 1;
    private static final int BUFFER_SIZE = 1400;
    private ByteArrayOutputStream _Stream = new ByteArrayOutputStream(1400);
    private ByteBuffer _Buffer = ByteBuffer.allocateDirect(1400);

    PerfXML() {
    }

    public void run() {
        this.println("/////////////////////////////");
        this.println("// Package: javolution.xml //");
        this.println("/////////////////////////////");
        this.println("");
        this.println("-- Java(TM) Serialization --");
        this.benchmarkJavaSerialization();
        this.println("");
        this.println("-- XML Serialization (I/O Stream) --");
        this.benchmarkXmlIoSerialization();
        this.println("");
        this.println("-- XML Serialization (NIO ByteBuffer) --");
        this.benchmarkXmlNioSerialization();
        this.println("");
    }

    private void benchmarkJavaSerialization() {
        try {
            Object object;
            ObjectOutputStream objectOutputStream;
            int n;
            this.print("Write Time: ");
            for (n = 0; n < 1000; ++n) {
                objectOutputStream = new ObjectOutputStream(this._Stream);
                object = PerfXML.newData();
                this.startTime();
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                this.keepBestTime(1);
                this._Stream.reset();
            }
            this.println(this.endTime());
            this.print("Read Time: ");
            for (n = 0; n < 1000; ++n) {
                objectOutputStream = new ObjectOutputStream(this._Stream);
                object = PerfXML.newData();
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._Stream.toByteArray());
                this._Stream.reset();
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.startTime();
                Object object2 = objectInputStream.readObject();
                objectInputStream.close();
                this.keepBestTime(1);
                if (object.equals(object2)) continue;
                throw new Error("SERIALIZATION ERROR");
            }
            this.println(this.endTime());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.println("NOT SUPPORTED (J2SE 1.4+ build required)");
        }
        catch (Throwable throwable) {
            throw new JavolutionError(throwable);
        }
    }

    private void benchmarkXmlIoSerialization() {
        XMLBinding xMLBinding = new XMLBinding();
        xMLBinding.setAlias(String.class, "String");
        try {
            Object object;
            XMLObjectWriter xMLObjectWriter;
            int n;
            this.print("Write Time: ");
            for (n = 0; n < 1000; ++n) {
                xMLObjectWriter = XMLObjectWriter.newInstance(this._Stream);
                xMLObjectWriter.setBinding(xMLBinding);
                object = PerfXML.newData();
                this.startTime();
                xMLObjectWriter.write(object);
                xMLObjectWriter.close();
                this.keepBestTime(1);
                this._Stream.reset();
            }
            this.println(this.endTime());
            this.print("Read Time: ");
            for (n = 0; n < 1000; ++n) {
                xMLObjectWriter = XMLObjectWriter.newInstance(this._Stream);
                xMLObjectWriter.setBinding(xMLBinding);
                object = PerfXML.newData();
                xMLObjectWriter.write(object);
                xMLObjectWriter.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._Stream.toByteArray());
                this._Stream.reset();
                XMLObjectReader xMLObjectReader = XMLObjectReader.newInstance(byteArrayInputStream);
                xMLObjectReader.setBinding(xMLBinding);
                this.startTime();
                Object t = xMLObjectReader.read();
                xMLObjectReader.close();
                this.keepBestTime(1);
                if (object.equals(t)) continue;
                throw new Error("SERIALIZATION ERROR");
            }
            this.println(this.endTime());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.println("NOT SUPPORTED (J2SE 1.4+ build required)");
        }
        catch (Throwable throwable) {
            throw new JavolutionError(throwable);
        }
    }

    private void benchmarkXmlNioSerialization() {
        try {
            Object object;
            XMLObjectWriter xMLObjectWriter;
            int n;
            this.print("Write Time: ");
            for (n = 0; n < 1000; ++n) {
                xMLObjectWriter = XMLObjectWriter.newInstance(new UTF8ByteBufferWriter().setOutput(this._Buffer));
                object = PerfXML.newData();
                this.startTime();
                xMLObjectWriter.write(object);
                xMLObjectWriter.close();
                this.keepBestTime(1);
                this._Buffer.clear();
            }
            this.println(this.endTime());
            this.print("Read Time: ");
            for (n = 0; n < 1000; ++n) {
                xMLObjectWriter = XMLObjectWriter.newInstance(new UTF8ByteBufferWriter().setOutput(this._Buffer));
                object = PerfXML.newData();
                xMLObjectWriter.write(object);
                xMLObjectWriter.close();
                this._Buffer.flip();
                XMLObjectReader xMLObjectReader = XMLObjectReader.newInstance(new UTF8ByteBufferReader().setInput(this._Buffer));
                this.startTime();
                Object t = xMLObjectReader.read();
                xMLObjectReader.close();
                this.keepBestTime(1);
                if (!object.equals(t)) {
                    throw new Error("SERIALIZATION ERROR");
                }
                this._Buffer.clear();
            }
            this.println(this.endTime());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.println("NOT SUPPORTED (J2SE 1.4+ build required)");
        }
        catch (Throwable throwable) {
            throw new JavolutionError(throwable);
        }
    }

    private static Object newData() {
        FastTable<RealtimeObject> fastTable = new FastTable<RealtimeObject>(1);
        for (int i = 0; i < 1; ++i) {
            FastTable<String> fastTable2 = new FastTable<String>();
            fastTable2.add("This is the first String (" + i + ")");
            fastTable2.add("This is the second String (" + i + ")");
            fastTable2.add("This is the third String (" + i + ")");
            fastTable.add(fastTable2);
            fastTable.add(null);
            fastTable.add(TextBuilder.newInstance().append(Long.MAX_VALUE));
            fastTable.add(Text.valueOf(Long.MAX_VALUE, 16));
            FastMap<Object, String> fastMap = new FastMap<Object, String>();
            fastMap.setKeyComparator(FastComparator.IDENTITY);
            fastMap.put(Index.valueOf(i), "INDEX+" + i);
            fastMap.put(Index.valueOf(-i), "INDEX-" + i);
            fastTable.add(fastMap);
            FastList<String> fastList = new FastList<String>();
            fastList.add("FIRST(" + i + ")");
            fastList.add("SECOND(" + i + ")");
            fastList.add("THIRD(" + i + ")");
            fastList.add("<&'>>>");
            fastTable.add(fastList);
            FastSet<Serializable> fastSet = new FastSet<Serializable>();
            fastSet.add(new Integer(MathLib.random(Integer.MIN_VALUE, Integer.MAX_VALUE)));
            fastSet.add(new Long(MathLib.random(Long.MIN_VALUE, Long.MAX_VALUE)));
            fastSet.add("".getClass());
            fastTable.add(fastSet);
        }
        return fastTable;
    }
}

