/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.JavolutionError;
import javolution.context.ObjectFactory;
import javolution.context.PoolContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectPool<T> {
    transient Thread _user;
    transient boolean _inUse;
    transient ObjectPool<T> _outer;

    protected ObjectPool() {
    }

    public final Thread getUser() {
        return this._user;
    }

    public final boolean isLocal() {
        if (this._user == Thread.currentThread()) {
            return true;
        }
        if (!this._inUse) {
            throw new JavolutionError("Access to inner pool or unused pool detected");
        }
        if (this._user == null) {
            return false;
        }
        throw new JavolutionError("Concurrent access to local pool detected");
    }

    public final boolean inUse() {
        return this._inUse;
    }

    public final ObjectPool getOuter() {
        if (!this.isLocal()) {
            throw new JavolutionError("Not supported for non-local pool");
        }
        PoolContext poolContext = PoolContext.current();
        return poolContext != null ? poolContext.getOuter().getLocalPools().getPool(this.getFactory(), false) : null;
    }

    public abstract ObjectFactory getFactory();

    public abstract int getSize();

    public abstract void setSize(int var1);

    public abstract T next();

    public abstract void recycle(T var1);

    protected abstract void recycleAll();

    protected abstract void clearAll();
}

