/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.context.Context;
import javolution.context.HeapContext;
import javolution.context.LocalContext;
import javolution.context.LocalPools;
import javolution.context.RealtimeObject;
import javolution.text.Text;
import javolution.util.FastTable;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public class PoolContext
extends Context {
    private static RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        protected Object create() {
            return new PoolContext();
        }
    };
    private static final LocalContext.Reference ENABLED = new LocalContext.Reference<Boolean>(new Boolean(true));
    static final XMLFormat XML = new XMLFormat(Javolution.j2meGetClass("javolution.context.PoolContext")){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            PoolContext poolContext = (PoolContext)object;
            Class<?> clazz = poolContext._allPools.getClass();
            poolContext._allPools.addAll((FastTable)inputElement.get("Pools", clazz));
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            PoolContext poolContext = (PoolContext)object;
            Class<?> clazz = poolContext._allPools.getClass();
            outputElement.add(poolContext._allPools, "Pools", clazz);
        }
    };
    private final FastTable _allPools = new FastTable();
    private boolean _isEnabled = true;
    private final ThreadLocal _localPools = new ThreadLocal(){
        private Runnable _createLocalPools = new Runnable(){

            public void run() {
                LocalPools localPools = new LocalPools(true);
                localPools._owner = Thread.currentThread();
                PoolContext.this._allPools.add(localPools);
            }
        };

        protected synchronized Object initialValue() {
            for (int i = 0; i < PoolContext.this._allPools.size(); ++i) {
                LocalPools localPools = (LocalPools)PoolContext.this._allPools.get(i);
                if (localPools._owner != null) continue;
                localPools._owner = Thread.currentThread();
                return localPools;
            }
            MemoryArea.getMemoryArea(PoolContext.this).executeInArea(this._createLocalPools);
            return PoolContext.this._allPools.getLast();
        }
    };
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    private transient boolean _isInternal;

    public static PoolContext current() {
        for (Context context = Context.current(); context != null; context = context.getOuter()) {
            if (context instanceof PoolContext) {
                return (PoolContext)context;
            }
            if (!(context instanceof HeapContext)) continue;
            return null;
        }
        throw new JavolutionError("No heap context or pool context");
    }

    public static void setEnabled(boolean bl) {
        ENABLED.set(bl ? TRUE : FALSE);
    }

    public static boolean isEnabled() {
        return (Boolean)ENABLED.get();
    }

    public static void enter() {
        PoolContext poolContext = (PoolContext)FACTORY.object();
        poolContext._isInternal = true;
        poolContext._isEnabled = PoolContext.isEnabled();
        Context.enter(poolContext);
    }

    public static void exit() {
        PoolContext poolContext = (PoolContext)Context.current();
        if (!poolContext._isInternal) {
            throw new UnsupportedOperationException("The context to exit must be specified");
        }
        poolContext._isInternal = false;
        Context.exitNoCheck(poolContext);
        FACTORY.recycle(poolContext);
    }

    public void clear() {
        for (int i = 0; i < this._allPools.size(); ++i) {
            ((LocalPools)this._allPools.get(i)).clear();
        }
    }

    public Text toText() {
        return this._allPools.toText();
    }

    protected void enterAction() {
        Context context = this.getOuter();
        context.getLocalPools().deactivatePools();
        this.getLocalPools().activatePools();
    }

    protected void exitAction() {
        if (this._isEnabled) {
            for (int i = 0; i < this._allPools.size(); ++i) {
                ((LocalPools)this._allPools.get(i)).reset();
            }
        }
        this.getLocalPools().deactivatePools();
        Context context = this.getOuter();
        context.getLocalPools().activatePools();
    }

    final LocalPools getLocalPools() {
        return this._isEnabled ? (LocalPools)this._localPools.get() : Context.ROOT.getLocalPools();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Reference<T>
    extends RealtimeObject
    implements javolution.lang.Reference<T> {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            protected Object create() {
                return new Reference();
            }

            protected void cleanup(Object object) {
                ((Reference)object)._value = null;
            }
        };
        private T _value;

        private Reference() {
        }

        public static <T> Reference<T> newInstance() {
            return (Reference)FACTORY.object();
        }

        public void recycle() {
            FACTORY.recycle(this);
        }

        @Override
        public Text toText() {
            return Text.valueOf(this.get());
        }

        @Override
        public T get() {
            return this._value;
        }

        @Override
        public void set(T t) {
            this._value = t;
        }
    }
}

