/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import java.text.ParsePosition;
import javolution.context.ObjectFactory;
import javolution.text.CharSet;
import javolution.text.Text;
import javolution.text.TextBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextFormat<T> {
    protected TextFormat() {
    }

    public abstract Appendable format(T var1, Appendable var2) throws IOException;

    public abstract T parse(CharSequence var1, Cursor var2);

    public final Text format(T t) {
        try {
            TextBuilder textBuilder = TextBuilder.newInstance();
            this.format(t, textBuilder);
            return textBuilder.toText();
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    public final T parse(CharSequence charSequence) {
        Cursor cursor = Cursor.newInstance(0, charSequence.length());
        T t = this.parse(charSequence, cursor);
        if (cursor.hasNext()) {
            throw new IllegalArgumentException("Incomplete Parsing");
        }
        Cursor.recycle(cursor);
        return t;
    }

    public static class Cursor
    extends ParsePosition {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            public Object create() {
                return new Cursor();
            }
        };
        private int _index;
        private int _start;
        private int _end;

        private Cursor() {
            super(0);
        }

        public static Cursor newInstance(int n, int n2) {
            Cursor cursor = (Cursor)FACTORY.object();
            cursor._start = cursor._index = n;
            cursor._end = n2;
            cursor.setErrorIndex(-1);
            return cursor;
        }

        public static void recycle(Cursor cursor) {
            FACTORY.recycle(cursor);
        }

        public final int getIndex() {
            return this._index;
        }

        public final int getStartIndex() {
            return this._start;
        }

        public final int getEndIndex() {
            return this._end;
        }

        public final int getErrorIndex() {
            int n = this.getErrorIndex();
            return n >= 0 ? n : this._index;
        }

        public final void setIndex(int n) {
            if (n < this._start || n > this._end) {
                throw new IllegalArgumentException();
            }
            this._index = n;
        }

        public final void setStartIndex(int n) {
            this._start = n;
        }

        public final void setEndIndex(int n) {
            this._end = n;
        }

        public final void setErrorIndex(int n) {
            super.setErrorIndex(n);
        }

        public final boolean hasNext() {
            return this._index < this._end;
        }

        public final char next(CharSequence charSequence) {
            return this._index < this._end ? charSequence.charAt(this._index++) : (char)'\u0000';
        }

        public final boolean at(char c, CharSequence charSequence) {
            return this._index < this._end && charSequence.charAt(this._index) == c;
        }

        public final boolean at(CharSet charSet, CharSequence charSequence) {
            return this._index < this._end && charSet.contains(charSequence.charAt(this._index));
        }

        public final boolean at(String string, CharSequence charSequence) {
            return this._index < this._end && charSequence.charAt(this._index) == string.charAt(0) ? this.match(string, charSequence) : false;
        }

        private final boolean match(String string, CharSequence charSequence) {
            int n = 1;
            int n2 = this._index + 1;
            int n3 = string.length();
            int n4 = this._end;
            while (n < n3) {
                if (n2 < n4 && charSequence.charAt(n2++) == string.charAt(n++)) continue;
                return false;
            }
            return true;
        }

        public final boolean skip(char c, CharSequence charSequence) {
            while (this._index < this._end && charSequence.charAt(this._index) == c) {
                ++this._index;
            }
            return this._index < this._end;
        }

        public final boolean skip(CharSet charSet, CharSequence charSequence) {
            while (this._index < this._end && charSet.contains(charSequence.charAt(this._index))) {
                ++this._index;
            }
            return this._index < this._end;
        }

        public final Cursor increment() {
            ++this._index;
            return this;
        }

        public final Cursor increment(int n) {
            this._index += n;
            return this;
        }

        public String toString() {
            return String.valueOf(this._index);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Cursor)) {
                return false;
            }
            return this._index == ((Cursor)object)._index;
        }

        public int hashCode() {
            return this._index;
        }
    }
}

