/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import javax.realtime.MemoryArea;
import javolution.context.PersistentContext;
import javolution.context.RealtimeObject;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastList;
import javolution.util.Index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastTable<E>
extends FastCollection<E>
implements List<E>,
Reusable,
RandomAccess {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new FastTable();
        }

        public void cleanup(Object object) {
            ((FastTable)object).reset();
        }
    };
    private static final int D0 = 5;
    private static final int M0 = 31;
    private static final int C0 = 32;
    private static final int D1 = 7;
    private static final int R1 = 5;
    private static final int M1 = 127;
    private static final int C1 = 4096;
    private static final int D2 = 9;
    private static final int R2 = 12;
    private static final int M2 = 511;
    private static final int C2 = 0x200000;
    private static final int D3 = 11;
    private static final int R3 = 21;
    private transient E[][] _elems1;
    private transient E[][][] _elems2;
    private transient E[][][][] _elems3;
    private transient int _capacity = 32;
    private transient int _size;
    private transient FastComparator<? super E> _valueComparator = FastComparator.DEFAULT;
    private static final Object[] NULL_BLOCK = new Object[32];
    private static final long serialVersionUID = 1L;

    public FastTable() {
        this._elems1 = new Object[1][];
        this._elems1[0] = new Object[32];
    }

    public FastTable(String string) {
        this();
        new PersistentContext.Reference(string, this){

            protected void notifyChange() {
                FastTable.this.clear();
                FastTable.this.addAll((FastList)this.get());
            }
        };
    }

    public FastTable(int n) {
        this();
        while (n > this._capacity) {
            this.increaseCapacity();
        }
    }

    public FastTable(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public static <E> FastTable<E> newInstance() {
        return (FastTable)FACTORY.object();
    }

    public static void recycle(FastTable fastTable) {
        FACTORY.recycle(fastTable);
    }

    protected final int getCapacity() {
        return this._capacity;
    }

    @Override
    public final E get(int n) {
        if (n >> 12 == 0 && n < this._size) {
            return this._elems1[n >> 5][n & 0x1F];
        }
        return this.get2(n);
    }

    private final E get2(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return n < 0x200000 ? this._elems2[n >> 12][n >> 5 & 0x7F][n & 0x1F] : this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n & 0x1F];
    }

    @Override
    public final E set(int n, E e) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        E[] EArray = n < 4096 ? this._elems1[n >> 5] : (n < 0x200000 ? this._elems2[n >> 12][n >> 5 & 0x7F] : this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F]);
        E e2 = EArray[n & 0x1F];
        EArray[n & 0x1F] = e;
        return e2;
    }

    @Override
    public final boolean add(E e) {
        int n = this._size;
        if (n >= this._capacity) {
            this.increaseCapacity();
        }
        E[] EArray = n < 4096 ? this._elems1[n >> 5] : (n < 0x200000 ? this._elems2[n >> 12][n >> 5 & 0x7F] : this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F]);
        EArray[n & 0x1F] = e;
        ++this._size;
        return true;
    }

    @Override
    public final E getFirst() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this._elems1[0][0];
    }

    @Override
    public final E getLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        int n = this._size - 1;
        E[] EArray = n < 4096 ? this._elems1[n >> 5] : (n < 0x200000 ? this._elems2[n >> 12][n >> 5 & 0x7F] : this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F]);
        return EArray[n & 0x1F];
    }

    @Override
    public final void addLast(E e) {
        this.add(e);
    }

    @Override
    public final E removeLast() {
        int n;
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        E[] EArray = (n = --this._size) < 4096 ? this._elems1[n >> 5] : (n < 0x200000 ? this._elems2[n >> 12][n >> 5 & 0x7F] : this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F]);
        E e = EArray[n & 0x1F];
        EArray[n & 0x1F] = null;
        return e;
    }

    @Override
    public final void clear() {
        int n = this._size;
        this._size = 0;
        int n2 = Math.min(n, 32);
        for (int i = 0; i < n; i += 32) {
            E[] EArray = i < 4096 ? this._elems1[i >> 5] : (i < 0x200000 ? this._elems2[i >> 12][i >> 5 & 0x7F] : this._elems3[i >> 21][i >> 12 & 0x1FF][i >> 5 & 0x7F]);
            System.arraycopy(NULL_BLOCK, 0, EArray, 0, n2);
        }
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        int n2 = collection.size();
        int n3 = this._size;
        int n4 = n3 + n2;
        while (n4 >= this._capacity) {
            this.increaseCapacity();
        }
        this._size = n4;
        int n5 = n3;
        while (--n5 >= n) {
            this.set(n5 + n2, this.get(n5));
        }
        Iterator<E> iterator = collection.iterator();
        int n6 = n + n2;
        for (int i = n; i < n6; ++i) {
            this.set(i, iterator.next());
        }
        return n2 != 0;
    }

    @Override
    public final void add(int n, E e) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        int n2 = this._size;
        int n3 = n2 + 1;
        if (n3 >= this._capacity) {
            this.increaseCapacity();
        }
        this._size = n3;
        int n4 = n;
        int n5 = n3;
        while (n4 < n5) {
            e = this.set(n4++, e);
        }
    }

    @Override
    public final E remove(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        int n2 = this._size - 1;
        E e = this.get(n2);
        int n3 = n2;
        while (--n3 >= n) {
            e = this.set(n3, e);
        }
        this.set(n2, null);
        this._size = n2;
        return e;
    }

    public final void removeRange(int n, int n2) {
        int n3 = this._size;
        if (n < 0 || n2 < 0 || n > n2 || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n2;
        int n5 = n;
        while (n4 < n3) {
            this.set(n5++, this.get(n4++));
        }
        n5 = n4 = n3 - n2 + n;
        while (n5 < n3) {
            this.set(n5++, null);
        }
        this._size = n4;
    }

    @Override
    public final int indexOf(Object object) {
        FastComparator<E> fastComparator = this.getValueComparator();
        int n = -1;
        while (++n < this._size) {
            if (!fastComparator.areEqual(object, this.get(n))) continue;
            return n;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        FastComparator<E> fastComparator = this.getValueComparator();
        int n = this._size;
        while (--n >= 0) {
            if (!fastComparator.areEqual(object, this.get(n))) continue;
            return n;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        FastTableIterator fastTableIterator = (FastTableIterator)FastTableIterator.FACTORY.object();
        fastTableIterator._table = this;
        fastTableIterator._start = 0;
        fastTableIterator._end = this._size;
        fastTableIterator._nextIndex = 0;
        fastTableIterator._currentIndex = -1;
        return fastTableIterator;
    }

    @Override
    public ListIterator<E> listIterator() {
        FastTableIterator fastTableIterator = (FastTableIterator)FastTableIterator.FACTORY.object();
        fastTableIterator._table = this;
        fastTableIterator._start = 0;
        fastTableIterator._end = this._size;
        fastTableIterator._nextIndex = 0;
        fastTableIterator._currentIndex = -1;
        return fastTableIterator;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n >= 0 && n <= this._size) {
            FastTableIterator fastTableIterator = (FastTableIterator)FastTableIterator.FACTORY.object();
            fastTableIterator._table = this;
            fastTableIterator._start = 0;
            fastTableIterator._end = this._size;
            fastTableIterator._nextIndex = n;
            fastTableIterator._currentIndex = -1;
            return fastTableIterator;
        }
        throw new IndexOutOfBoundsException("index: " + n + " for table of size: " + this._size);
    }

    @Override
    public final List<E> subList(int n, int n2) {
        if (n < 0 || n2 > this._size || n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
        }
        SubTable subTable = (SubTable)SubTable.FACTORY.object();
        subTable._table = this;
        subTable._offset = n;
        subTable._size = n2 - n;
        return subTable;
    }

    public final void trimToSize() {
        while (this._capacity > this._size + 32) {
            this.decreaseCapacity();
        }
    }

    public final void sort() {
        if (this._size > 1) {
            this.quicksort(0, this._size - 1, this.getValueComparator());
        }
    }

    private void quicksort(int n, int n2, FastComparator fastComparator) {
        int n3 = 0;
        if (n < n2) {
            n3 = this.partition(n, n2, fastComparator);
            this.quicksort(n, n3 - 1, fastComparator);
            this.quicksort(n3 + 1, n2, fastComparator);
        }
    }

    private int partition(int n, int n2, FastComparator fastComparator) {
        E e = this.get(n);
        int n3 = n;
        int n4 = n2;
        while (true) {
            if (fastComparator.compare(this.get(n3), e) <= 0 && n3 < n2) {
                ++n3;
                continue;
            }
            while (fastComparator.compare(this.get(n4), e) > 0 && n4 > n) {
                --n4;
            }
            if (n3 < n4) {
                E e2 = this.get(n3);
                this.set(n3, this.get(n4));
                this.set(n4, e2);
            }
            if (n4 <= n3) break;
        }
        this.set(n, this.get(n4));
        this.set(n4, e);
        return n4;
    }

    public FastTable<E> setValueComparator(FastComparator<? super E> fastComparator) {
        this._valueComparator = fastComparator;
        return this;
    }

    @Override
    public FastComparator<? super E> getValueComparator() {
        return this._valueComparator;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final FastCollection.Record head() {
        return Index.valueOf(-1);
    }

    @Override
    public final FastCollection.Record tail() {
        return Index.valueOf(this._size);
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return this.get(((Index)record).intValue());
    }

    @Override
    public final void delete(FastCollection.Record record) {
        this.remove(((Index)record).intValue());
    }

    @Override
    public List<E> unmodifiable() {
        return (List)super.unmodifiable();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._capacity = 32;
        this._elems1 = new Object[1][];
        this._elems1[0] = new Object[32];
        this.setValueComparator((FastComparator)objectInputStream.readObject());
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.addLast(objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getValueComparator());
        int n = this._size;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(this.get(i));
        }
    }

    protected void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                int n = FastTable.this._capacity;
                FastTable.this._capacity += 32;
                if (n < 4096) {
                    if (FastTable.this._elems1.length == 1) {
                        Object[][] objectArray = new Object[128][];
                        objectArray[0] = FastTable.this._elems1[0];
                        FastTable.access$1102(FastTable.this, objectArray);
                    }
                    ((FastTable)FastTable.this)._elems1[n >> 5] = new Object[32];
                } else if (n < 0x200000) {
                    if (FastTable.this._elems2 == null) {
                        FastTable.access$1202(FastTable.this, new Object[512][][]);
                    }
                    if (FastTable.this._elems2[n >> 12] == null) {
                        ((FastTable)FastTable.this)._elems2[n >> 12] = new Object[128][];
                    }
                    ((FastTable)FastTable.this)._elems2[n >> 12][n >> 5 & 0x7F] = new Object[32];
                } else {
                    if (FastTable.this._elems3 == null) {
                        FastTable.access$1302(FastTable.this, new Object[11][][][]);
                    }
                    if (FastTable.this._elems3[n >> 21] == null) {
                        ((FastTable)FastTable.this)._elems3[n >> 21] = new Object[9][][];
                    }
                    if (FastTable.this._elems3[n >> 21][n >> 12 & 0x1FF] == null) {
                        ((FastTable)FastTable.this)._elems3[n >> 21][n >> 12 & 0x1FF] = new Object[7][];
                    }
                    ((FastTable)FastTable.this)._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F] = new Object[5];
                }
            }
        });
    }

    protected void decreaseCapacity() {
        if (this._size >= this._capacity - 32) {
            return;
        }
        int n = this._capacity;
        this._capacity -= 32;
        if (n < 4096) {
            this._elems1[n >> 5] = null;
            this._elems2 = null;
            this._elems3 = null;
        } else if (n < 0x200000) {
            this._elems2[n >> 12][n >> 5 & 0x7F] = null;
            this._elems3 = null;
        } else {
            this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F] = null;
        }
    }

    static /* synthetic */ Object[][] access$1102(FastTable fastTable, Object[][] objectArray) {
        fastTable._elems1 = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[][][] access$1202(FastTable fastTable, Object[][][] objectArray) {
        fastTable._elems2 = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[][][][] access$1302(FastTable fastTable, Object[][][][] objectArray) {
        fastTable._elems3 = objectArray;
        return objectArray;
    }

    private static final class SubTable
    extends FastCollection
    implements List,
    RandomAccess {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            protected Object create() {
                return new SubTable();
            }

            protected void cleanup(Object object) {
                SubTable subTable = (SubTable)object;
                subTable._table = null;
            }
        };
        private FastTable _table;
        private int _offset;
        private int _size;

        private SubTable() {
        }

        public int size() {
            return this._size;
        }

        public FastCollection.Record head() {
            return Index.valueOf(-1);
        }

        public FastCollection.Record tail() {
            return Index.valueOf(this._size);
        }

        public Object valueOf(FastCollection.Record record) {
            return this._table.get(((Index)record).intValue() + this._offset);
        }

        public void delete(FastCollection.Record record) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        public Object get(int n) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            return this._table.get(n + this._offset);
        }

        public Object set(int n, Object object) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            return this._table.set(n + this._offset, object);
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        public int indexOf(Object object) {
            FastComparator fastComparator = this._table.getValueComparator();
            int n = -1;
            while (++n < this._size) {
                if (!fastComparator.areEqual(object, this._table.get(n + this._offset))) continue;
                return n;
            }
            return -1;
        }

        public int lastIndexOf(Object object) {
            FastComparator fastComparator = this._table.getValueComparator();
            int n = this._size;
            while (--n >= 0) {
                if (!fastComparator.areEqual(object, this._table.get(n + this._offset))) continue;
                return n;
            }
            return -1;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n) {
            if (n >= 0 && n <= this._size) {
                FastTableIterator fastTableIterator = (FastTableIterator)FastTableIterator.FACTORY.object();
                fastTableIterator._table = this._table;
                fastTableIterator._start = this._offset;
                fastTableIterator._end = this._offset + this._size;
                fastTableIterator._nextIndex = n + this._offset;
                return fastTableIterator;
            }
            throw new IndexOutOfBoundsException("index: " + n + " for table of size: " + this._size);
        }

        public List subList(int n, int n2) {
            if (n < 0 || n2 > this._size || n > n2) {
                throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
            }
            SubTable subTable = (SubTable)FACTORY.object();
            subTable._table = this._table;
            subTable._offset = this._offset + n;
            subTable._size = n2 - n;
            return subTable;
        }
    }

    private static final class FastTableIterator
    extends RealtimeObject
    implements ListIterator {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            protected Object create() {
                return new FastTableIterator();
            }

            protected void cleanup(Object object) {
                FastTableIterator fastTableIterator = (FastTableIterator)object;
                fastTableIterator._table = null;
            }
        };
        private FastTable _table;
        private int _currentIndex;
        private int _start;
        private int _end;
        private int _nextIndex;

        private FastTableIterator() {
        }

        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        public Object next() {
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            this._currentIndex = this._nextIndex++;
            return this._table.get(this._currentIndex);
        }

        public int nextIndex() {
            return this._nextIndex;
        }

        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        public Object previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            return this._table.get(this._nextIndex);
        }

        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void add(Object object) {
            this._table.add(this._nextIndex++, object);
            ++this._end;
            this._currentIndex = -1;
        }

        public void set(Object object) {
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._table.set(this._currentIndex, object);
        }

        public void remove() {
            if (this._currentIndex >= 0) {
                this._table.remove(this._currentIndex);
                --this._end;
                if (this._currentIndex < this._nextIndex) {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this._currentIndex = -1;
        }
    }
}

