/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javolution.context.LocalContext;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalMap<K, V>
implements Map<K, V> {
    private final LocalContext.Reference _mapRef = new LocalContext.Reference(new FastMap().setShared(true));

    public LocalMap<K, V> setKeyComparator(FastComparator<? super K> fastComparator) {
        this.localMap().setKeyComparator(fastComparator);
        return this;
    }

    public LocalMap<K, V> setValueComparator(FastComparator<? super V> fastComparator) {
        this.localMap().setValueComparator(fastComparator);
        return this;
    }

    public V putDefault(K k, V v) {
        return ((FastMap)this._mapRef.getDefault()).put(k, v);
    }

    @Override
    public int size() {
        return ((FastMap)this._mapRef.get()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((FastMap)this._mapRef.get()).isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return ((FastMap)this._mapRef.get()).containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return ((FastMap)this._mapRef.get()).containsValue(object);
    }

    @Override
    public V get(Object object) {
        return ((FastMap)this._mapRef.get()).get(object);
    }

    @Override
    public V put(K k, V v) {
        return this.localMap().put(k, v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.localMap().putAll(map);
    }

    @Override
    public V remove(Object object) {
        return this.put(object, null);
    }

    @Override
    public void clear() {
        FastMap<K, V> fastMap = this.localMap();
        FastCollection.Record record = fastMap.head();
        FastMap.Entry<K, V> entry = fastMap.tail();
        while ((record = ((FastMap.Entry)record).getNext()) != entry) {
            ((FastMap.Entry)record).setValue(null);
        }
    }

    @Override
    public Set<K> keySet() {
        return this.localMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.localMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.localMap().entrySet();
    }

    private FastMap<K, V> localMap() {
        FastMap fastMap = (FastMap)this._mapRef.getLocal();
        return fastMap != null ? fastMap : this.newLocalMap();
    }

    private FastMap newLocalMap() {
        FastMap fastMap = (FastMap)this._mapRef.get();
        FastMap fastMap2 = FastMap.newInstance();
        fastMap2.setShared(true);
        fastMap2.setKeyComparator(fastMap.getKeyComparator());
        fastMap2.setValueComparator(fastMap.getValueComparator());
        fastMap2.putAll(fastMap);
        this._mapRef.set(fastMap2);
        return fastMap2;
    }
}

