/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

public class ExtraMath {
    public static double LOG10 = Math.log(10.0);
    public static double EPSILON = Math.pow(2.0, -52.0);
    public static double CLOSE = EPSILON * 2.0;

    public static double log10(double v) {
        return Math.log(v) / LOG10;
    }

    public static double hypot(double v, double w) {
        if ((v = Math.abs(v)) < (w = Math.abs(w))) {
            double temp = v;
            v = w;
            w = temp;
        }
        if (v == 0.0) {
            return 0.0;
        }
        double wv = w / v;
        return v * Math.sqrt(1.0 + wv * wv);
    }

    public static boolean close(double v, double w, double tol) {
        if (v == w) {
            return true;
        }
        double scaled = tol * (Math.abs(v) + Math.abs(w)) / 2.0;
        return Math.abs(w - v) < scaled;
    }

    public static boolean close(double v, double w) {
        return ExtraMath.close(v, w, CLOSE);
    }

    public static double closeFloor(double v) {
        double floor = Math.floor(v);
        return ExtraMath.close(v, floor + 1.0) ? floor + 1.0 : floor;
    }
}

