/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.PyTuple;

public class JavaImportHelper {
    protected static boolean tryAddPackage(String packageName, PyObject fromlist) {
        Map packages = JavaImportHelper.buildLoadedPackages();
        boolean packageAdded = false;
        if (JavaImportHelper.isLoadedPackage(packageName, packages)) {
            packageAdded = JavaImportHelper.addPackage(packageName);
        }
        String parentPackageName = packageName;
        int dotPos = 0;
        do {
            boolean parentAdded;
            if ((dotPos = parentPackageName.lastIndexOf(".")) <= 0 || !JavaImportHelper.isLoadedPackage(parentPackageName = parentPackageName.substring(0, dotPos), packages) || !(parentAdded = JavaImportHelper.addPackage(parentPackageName))) continue;
            packageAdded = true;
        } while (dotPos > 0);
        if (fromlist != null && fromlist != Py.EmptyTuple && fromlist instanceof PyTuple) {
            Iterator iterator = ((PyTuple)fromlist).iterator();
            while (iterator.hasNext()) {
                String fromName;
                Object obj = iterator.next();
                if (!(obj instanceof String) || "*".equals(fromName = (String)obj)) continue;
                boolean fromAdded = false;
                if (JavaImportHelper.isJavaClass(packageName, fromName)) {
                    fromAdded = JavaImportHelper.addPackage(packageName);
                    if (!fromAdded) continue;
                    packageAdded = true;
                    continue;
                }
                String fromPackageName = packageName + "." + fromName;
                if (!JavaImportHelper.isLoadedPackage(fromPackageName, packages) || !(fromAdded = JavaImportHelper.addPackage(fromPackageName))) continue;
                packageAdded = true;
            }
        }
        return packageAdded;
    }

    protected static boolean isLoadedPackage(String packageName) {
        return JavaImportHelper.isLoadedPackage(packageName, JavaImportHelper.buildLoadedPackages());
    }

    private static boolean isLoadedPackage(String javaPackageName, Map packages) {
        return packages.containsKey(javaPackageName);
    }

    private static Map buildLoadedPackages() {
        TreeMap<String, String> packageMap = new TreeMap<String, String>();
        Package[] packages = Package.getPackages();
        for (int i = 0; i < packages.length; ++i) {
            String packageName = packages[i].getName();
            packageMap.put(packageName, "");
            int dotPos = 0;
            do {
                if ((dotPos = packageName.lastIndexOf(".")) <= 0) continue;
                packageName = packageName.substring(0, dotPos);
                packageMap.put(packageName, "");
            } while (dotPos > 0);
        }
        return packageMap;
    }

    private static boolean isJavaClass(String packageName, String className) {
        if (className != null && className.length() > 0) {
            className = packageName.replace('.', '/') + "/" + className + ".class";
            return Thread.currentThread().getContextClassLoader().getResource(className) != null;
        }
        return false;
    }

    private static boolean addPackage(String packageName) {
        boolean added = false;
        PyObject module = Py.getSystemState().modules.__finditem__(packageName.intern());
        if (module == null || module == Py.None) {
            int dotPos;
            PyObject modules = Py.getSystemState().modules;
            do {
                String internedPackageName;
                if (modules.__finditem__(internedPackageName = packageName.intern()) == Py.None) {
                    modules.__delitem__(internedPackageName);
                }
                PyJavaPackage p = PySystemState.add_package(packageName);
                Py.getSystemState().modules.__setitem__(internedPackageName, (PyObject)p);
                added = true;
                dotPos = packageName.lastIndexOf(".");
                if (dotPos <= 0) continue;
                packageName = packageName.substring(0, dotPos);
            } while (dotPos > 0);
        }
        return added;
    }
}

