/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.SyspathArchive;
import org.python.core.imp;

public class ZipFileImporter
extends PyObject {
    private SyspathArchive archive;
    private String pathToArchive;

    public ZipFileImporter(PyObject path) {
        if (!(path instanceof SyspathArchive)) {
            throw Py.ImportError(path.toString());
        }
        this.archive = (SyspathArchive)path;
        String archiveName = SyspathArchive.getArchiveName(this.archive.string);
        this.pathToArchive = new File(archiveName).getAbsolutePath() + File.separatorChar;
    }

    public PyObject find_module(String name) {
        return this.find_module(name, Py.None);
    }

    public PyObject find_module(String name, PyObject path) {
        ZipModuleInfo zip = this.getModuleInfo(name, this.archive);
        return zip == null ? Py.None : new ZipFileLoader(zip);
    }

    public String toString() {
        return this.getType().toString();
    }

    private String getSubName(String name) {
        int x = name.lastIndexOf(".");
        if (x >= 0) {
            return name.substring(x + 1);
        }
        return name;
    }

    private ZipModuleInfo getModuleInfo(String name, SyspathArchive zipArchive) {
        boolean pkg;
        String entryName = this.getSubName(name);
        String sourceName = entryName + "/__init__.py";
        String compiledName = entryName + "/__init__$py.class";
        ZipEntry sourceEntry = zipArchive.getEntry(sourceName);
        ZipEntry compiledEntry = zipArchive.getEntry(compiledName);
        boolean bl = pkg = sourceEntry != null || compiledEntry != null;
        if (!pkg) {
            sourceName = entryName + ".py";
            compiledName = entryName + "$py.class";
            sourceEntry = zipArchive.getEntry(sourceName);
            compiledEntry = zipArchive.getEntry(compiledName);
        } else {
            zipArchive = zipArchive.makeSubfolder(entryName);
        }
        ZipModuleInfo info = null;
        if (sourceEntry != null) {
            Py.writeDebug("import", "trying source entry: " + sourceName + " from jar/zip file " + zipArchive);
            if (compiledEntry != null) {
                Py.writeDebug("import", "trying precompiled entry " + compiledName + " from jar/zip file " + zipArchive);
                long pyTime = sourceEntry.getTime();
                long classTime = compiledEntry.getTime();
                if (classTime >= pyTime) {
                    info = new ZipModuleInfo(zipArchive, compiledEntry, true);
                }
            }
            info = new ZipModuleInfo(zipArchive, sourceEntry, false);
        }
        if (pkg && info != null) {
            info.path = new PyList(new PyObject[]{zipArchive});
        }
        return info;
    }

    private class ZipModuleInfo {
        public PyObject path;
        public boolean compiled;
        public ZipEntry zipEntry;
        public SyspathArchive archive;

        public ZipModuleInfo(SyspathArchive archive, ZipEntry zipEntry, boolean compiled) {
            this(archive, zipEntry, compiled, null);
        }

        public ZipModuleInfo(SyspathArchive archive, ZipEntry zipEntry, boolean compiled, PyObject path) {
            this.path = path;
            this.archive = archive;
            this.zipEntry = zipEntry;
            this.compiled = compiled;
        }
    }

    public class ZipFileLoader
    extends PyObject {
        private ZipModuleInfo _info;

        public ZipFileLoader(ZipModuleInfo info) {
            this._info = info;
        }

        public PyObject load_module(String moduleName) {
            PyModule m = null;
            if (this._info.path != null) {
                m = imp.addModule(moduleName);
                m.__dict__.__setitem__("__path__", this._info.path);
                m.__dict__.__setitem__("__loader__", (PyObject)this);
            }
            InputStream is = null;
            ZipEntry entry = this._info.zipEntry;
            try {
                is = this._info.archive.getInputStream(entry);
            }
            catch (IOException e) {
                Py.writeDebug("import", "loadFromZipFile exception: " + e.toString());
                throw Py.ImportError("error loading from zipfile");
            }
            String pathToEntry = ZipFileImporter.this.pathToArchive + entry.getName();
            PyObject o = this._info.compiled ? imp.createFromPyClass(moduleName, is, true, pathToEntry) : imp.createFromSource(moduleName, is, pathToEntry, null);
            return m == null ? o : m;
        }

        public String toString() {
            return this.getType().toString();
        }
    }
}

