/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.python.core.BuiltinFunctions;
import org.python.core.ClassDictInit;
import org.python.core.CompilerFlags;
import org.python.core.ImportFunction;
import org.python.core.Py;
import org.python.core.PyCallIter;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyEnumerate;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyStringDerived;
import org.python.core.PyStringMap;
import org.python.core.PyTableCode;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyXRange;
import org.python.core.imp;

public class __builtin__
implements ClassDictInit {
    private static PyStringMap internedStrings;
    public static PyString __doc__zip;
    static /* synthetic */ Class class$org$python$core$PyObject;
    static /* synthetic */ Class class$org$python$core$PyType;
    static /* synthetic */ Class class$org$python$core$PyInteger;
    static /* synthetic */ Class class$org$python$core$PyEnumerate;
    static /* synthetic */ Class class$org$python$core$PyFloat;
    static /* synthetic */ Class class$org$python$core$PyLong;
    static /* synthetic */ Class class$org$python$core$PyComplex;
    static /* synthetic */ Class class$org$python$core$PyDictionary;
    static /* synthetic */ Class class$org$python$core$PyList;
    static /* synthetic */ Class class$org$python$core$PyTuple;
    static /* synthetic */ Class class$org$python$core$PyProperty;
    static /* synthetic */ Class class$org$python$core$PyStaticMethod;
    static /* synthetic */ Class class$org$python$core$PyClassMethod;
    static /* synthetic */ Class class$org$python$core$PySuper;
    static /* synthetic */ Class class$org$python$core$PyString;
    static /* synthetic */ Class class$org$python$core$PyUnicode;
    static /* synthetic */ Class class$org$python$core$PyBaseString;
    static /* synthetic */ Class class$org$python$core$PyFile;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("object", (PyObject)PyType.fromClass(class$org$python$core$PyObject == null ? (class$org$python$core$PyObject = __builtin__.class$("org.python.core.PyObject")) : class$org$python$core$PyObject));
        dict.__setitem__("type", (PyObject)PyType.fromClass(class$org$python$core$PyType == null ? (class$org$python$core$PyType = __builtin__.class$("org.python.core.PyType")) : class$org$python$core$PyType));
        dict.__setitem__("int", (PyObject)PyType.fromClass(class$org$python$core$PyInteger == null ? (class$org$python$core$PyInteger = __builtin__.class$("org.python.core.PyInteger")) : class$org$python$core$PyInteger));
        dict.__setitem__("enumerate", (PyObject)PyType.fromClass(class$org$python$core$PyEnumerate == null ? (class$org$python$core$PyEnumerate = __builtin__.class$("org.python.core.PyEnumerate")) : class$org$python$core$PyEnumerate));
        dict.__setitem__("float", (PyObject)PyType.fromClass(class$org$python$core$PyFloat == null ? (class$org$python$core$PyFloat = __builtin__.class$("org.python.core.PyFloat")) : class$org$python$core$PyFloat));
        dict.__setitem__("long", (PyObject)PyType.fromClass(class$org$python$core$PyLong == null ? (class$org$python$core$PyLong = __builtin__.class$("org.python.core.PyLong")) : class$org$python$core$PyLong));
        dict.__setitem__("complex", (PyObject)PyType.fromClass(class$org$python$core$PyComplex == null ? (class$org$python$core$PyComplex = __builtin__.class$("org.python.core.PyComplex")) : class$org$python$core$PyComplex));
        dict.__setitem__("dict", (PyObject)PyType.fromClass(class$org$python$core$PyDictionary == null ? (class$org$python$core$PyDictionary = __builtin__.class$("org.python.core.PyDictionary")) : class$org$python$core$PyDictionary));
        dict.__setitem__("list", (PyObject)PyType.fromClass(class$org$python$core$PyList == null ? (class$org$python$core$PyList = __builtin__.class$("org.python.core.PyList")) : class$org$python$core$PyList));
        dict.__setitem__("tuple", (PyObject)PyType.fromClass(class$org$python$core$PyTuple == null ? (class$org$python$core$PyTuple = __builtin__.class$("org.python.core.PyTuple")) : class$org$python$core$PyTuple));
        dict.__setitem__("property", (PyObject)PyType.fromClass(class$org$python$core$PyProperty == null ? (class$org$python$core$PyProperty = __builtin__.class$("org.python.core.PyProperty")) : class$org$python$core$PyProperty));
        dict.__setitem__("staticmethod", (PyObject)PyType.fromClass(class$org$python$core$PyStaticMethod == null ? (class$org$python$core$PyStaticMethod = __builtin__.class$("org.python.core.PyStaticMethod")) : class$org$python$core$PyStaticMethod));
        dict.__setitem__("classmethod", (PyObject)PyType.fromClass(class$org$python$core$PyClassMethod == null ? (class$org$python$core$PyClassMethod = __builtin__.class$("org.python.core.PyClassMethod")) : class$org$python$core$PyClassMethod));
        dict.__setitem__("super", (PyObject)PyType.fromClass(class$org$python$core$PySuper == null ? (class$org$python$core$PySuper = __builtin__.class$("org.python.core.PySuper")) : class$org$python$core$PySuper));
        dict.__setitem__("str", (PyObject)PyType.fromClass(class$org$python$core$PyString == null ? (class$org$python$core$PyString = __builtin__.class$("org.python.core.PyString")) : class$org$python$core$PyString));
        dict.__setitem__("unicode", (PyObject)PyType.fromClass(class$org$python$core$PyUnicode == null ? (class$org$python$core$PyUnicode = __builtin__.class$("org.python.core.PyUnicode")) : class$org$python$core$PyUnicode));
        dict.__setitem__("basestring", (PyObject)PyType.fromClass(class$org$python$core$PyBaseString == null ? (class$org$python$core$PyBaseString = __builtin__.class$("org.python.core.PyBaseString")) : class$org$python$core$PyBaseString));
        dict.__setitem__("file", (PyObject)PyType.fromClass(class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = __builtin__.class$("org.python.core.PyFile")) : class$org$python$core$PyFile));
        dict.__setitem__("None", Py.None);
        dict.__setitem__("NotImplemented", Py.NotImplemented);
        dict.__setitem__("Ellipsis", Py.Ellipsis);
        dict.__setitem__("True", (PyObject)Py.One);
        dict.__setitem__("False", (PyObject)Py.Zero);
        dict.__setitem__("__debug__", (PyObject)Py.One);
        dict.__setitem__("chr", (PyObject)new BuiltinFunctions("chr", 0, 1));
        dict.__setitem__("len", (PyObject)new BuiltinFunctions("len", 1, 1));
        dict.__setitem__("range", (PyObject)new BuiltinFunctions("range", 2, 1, 3));
        dict.__setitem__("ord", (PyObject)new BuiltinFunctions("ord", 3, 1));
        dict.__setitem__("globals", (PyObject)new BuiltinFunctions("globals", 4, 0));
        dict.__setitem__("hash", (PyObject)new BuiltinFunctions("hash", 5, 1));
        dict.__setitem__("cmp", (PyObject)new BuiltinFunctions("cmp", 6, 2));
        dict.__setitem__("apply", (PyObject)new BuiltinFunctions("apply", 9, 2, 3));
        dict.__setitem__("isinstance", (PyObject)new BuiltinFunctions("isinstance", 10, 2));
        dict.__setitem__("id", (PyObject)new BuiltinFunctions("id", 11, 1));
        dict.__setitem__("sum", (PyObject)new BuiltinFunctions("sum", 12, 1, 2));
        dict.__setitem__("__import__", (PyObject)new ImportFunction());
        dict.__delitem__("execfile_flags");
    }

    public static PyObject abs(PyObject o) {
        if (o.isNumberType()) {
            return o.__abs__();
        }
        throw Py.TypeError("bad operand type for abs()");
    }

    public static PyObject apply(PyObject o, PyObject args) {
        return o.__call__(Py.make_array(args));
    }

    public static PyObject apply(PyObject o, PyObject args, PyDictionary kws) {
        Hashtable table = kws.table;
        if (table.size() > 0) {
            Enumeration ek = table.keys();
            Enumeration ev = table.elements();
            int n = table.size();
            String[] kw = new String[n];
            PyObject[] aargs = Py.make_array(args);
            PyObject[] a = new PyObject[n + aargs.length];
            System.arraycopy(aargs, 0, a, 0, aargs.length);
            int offset = aargs.length;
            for (int i = 0; i < n; ++i) {
                kw[i] = ((PyString)ek.nextElement()).internedString();
                a[i + offset] = (PyObject)ev.nextElement();
            }
            return o.__call__(a, kw);
        }
        return __builtin__.apply(o, args);
    }

    public static PyObject bool(PyObject o) {
        return o == null ? Py.Zero : (o.__nonzero__() ? Py.One : Py.Zero);
    }

    public static boolean callable(PyObject o) {
        return o.__findattr__("__call__") != null;
    }

    public static char unichr(int i) {
        return __builtin__.chr(i);
    }

    public static char chr(int i) {
        if (i < 0 || i > 65535) {
            throw Py.ValueError("chr() arg not in range(65535)");
        }
        return (char)i;
    }

    public static int cmp(PyObject x, PyObject y) {
        return x._cmp(y);
    }

    public static PyTuple coerce(PyObject o1, PyObject o2) {
        PyObject[] result = o1._coerce(o2);
        if (result != null) {
            return new PyTuple(result);
        }
        throw Py.TypeError("number coercion failed");
    }

    public static PyCode compile(String data, String filename, String type) {
        return Py.compile_flags(data, filename, type, Py.getCompilerFlags());
    }

    public static PyCode compile(String data, String filename, String type, int flags, boolean dont_inherit) {
        if ((flags & 0xFFFFCFEF) != 0) {
            throw Py.ValueError("compile(): unrecognised flags");
        }
        return Py.compile_flags(data, filename, type, Py.getCompilerFlags(flags, dont_inherit));
    }

    public static void delattr(PyObject o, PyString n) {
        o.__delattr__(n);
    }

    public static PyObject dir(PyObject o) {
        PyList ret = (PyList)o.__dir__();
        ret.sort();
        return ret;
    }

    public static PyObject dir() {
        PyList ret;
        PyObject l = __builtin__.locals();
        if (l instanceof PyStringMap) {
            ret = ((PyStringMap)l).keys();
        } else if (l instanceof PyDictionary) {
            ret = ((PyDictionary)l).keys();
        }
        ret = (PyList)l.invoke("keys");
        ret.sort();
        return ret;
    }

    public static PyObject divmod(PyObject x, PyObject y) {
        return x._divmod(y);
    }

    public static PyEnumerate enumerate(PyObject seq) {
        return new PyEnumerate(seq);
    }

    /*
     * WARNING - void declaration
     */
    public static PyObject eval(PyObject o, PyObject globals, PyObject locals) {
        void var3_3;
        PyCode code;
        if (o instanceof PyCode) {
            code = (PyCode)o;
        } else if (o instanceof PyString) {
            code = __builtin__.compile(o.toString(), "<string>", "eval");
        } else {
            throw Py.TypeError("eval: argument 1 must be string or code object");
        }
        return Py.runCode((PyCode)var3_3, locals, globals);
    }

    public static PyObject eval(PyObject o, PyObject globals) {
        return __builtin__.eval(o, globals, globals);
    }

    public static PyObject eval(PyObject o) {
        if (o instanceof PyTableCode && ((PyTableCode)o).hasFreevars()) {
            throw Py.TypeError("code object passed to eval() may not contain free variables");
        }
        return __builtin__.eval(o, null, null);
    }

    public static void execfile(String name, PyObject globals, PyObject locals) {
        __builtin__.execfile_flags(name, globals, locals, Py.getCompilerFlags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execfile_flags(String name, PyObject globals, PyObject locals, CompilerFlags cflags) {
        PyCode code;
        FileInputStream file;
        try {
            file = new FileInputStream(name);
        }
        catch (FileNotFoundException e) {
            throw Py.IOError(e);
        }
        try {
            code = Py.compile_flags(file, name, "exec", cflags);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e) {
                throw Py.IOError(e);
            }
        }
        Py.runCode(code, locals, globals);
    }

    public static void execfile(String name, PyObject globals) {
        __builtin__.execfile(name, globals, globals);
    }

    public static void execfile(String name) {
        __builtin__.execfile(name, null, null);
    }

    public static PyObject filter(PyObject f, PyString s) {
        if (f == Py.None) {
            return s;
        }
        PyObject[] args = new PyObject[1];
        char[] chars = s.toString().toCharArray();
        int n = chars.length;
        int j = 0;
        for (int i = 0; i < n; ++i) {
            args[0] = Py.makeCharacter(chars[i]);
            if (!f.__call__(args).__nonzero__()) continue;
            chars[j++] = chars[i];
        }
        return new PyString(new String(chars, 0, j));
    }

    public static PyObject filter(PyObject f, PyObject l) {
        PyList list = new PyList();
        PyObject iter = l.__iter__();
        PyObject item = null;
        while ((item = iter.__iternext__()) != null) {
            if (f == Py.None ? !item.__nonzero__() : !f.__call__(item).__nonzero__()) continue;
            list.append(item);
        }
        if (l instanceof PyTuple) {
            return __builtin__.tuple(list);
        }
        return list;
    }

    public static PyObject getattr(PyObject o, PyString n) {
        return o.__getattr__(n);
    }

    public static PyObject getattr(PyObject o, PyString n, PyObject def) {
        PyObject val = o.__findattr__(n);
        if (val != null) {
            return val;
        }
        return def;
    }

    public static PyObject globals() {
        return Py.getFrame().f_globals;
    }

    public static boolean hasattr(PyObject o, PyString n) {
        try {
            return o.__findattr__(n) != null;
        }
        catch (PyException exc) {
            if (Py.matchException(exc, Py.AttributeError)) {
                return false;
            }
            throw exc;
        }
    }

    public static PyInteger hash(PyObject o) {
        return o.__hash__();
    }

    public static PyString hex(PyObject o) {
        return o.__hex__();
    }

    public static long id(PyObject o) {
        return Py.id(o);
    }

    public static PyObject input(PyObject prompt) {
        String line = __builtin__.raw_input(prompt);
        return __builtin__.eval(new PyString(line));
    }

    public static PyObject input() {
        return __builtin__.input(new PyString(""));
    }

    public static PyString intern(PyString s) {
        String istring;
        PyObject ret;
        if (internedStrings == null) {
            internedStrings = new PyStringMap();
        }
        if ((ret = internedStrings.__finditem__(istring = s.internedString())) != null) {
            return (PyString)ret;
        }
        if (s instanceof PyStringDerived) {
            s = s.__str__();
        }
        internedStrings.__setitem__(istring, (PyObject)s);
        return s;
    }

    public static boolean isinstance(PyObject obj, PyObject cls) {
        return Py.isInstance(obj, cls);
    }

    public static boolean issubclass(PyObject derived, PyObject cls) {
        return Py.isSubClass(derived, cls);
    }

    public static int len(PyObject o) {
        try {
            return o.__len__();
        }
        catch (PyException e) {
            if (e.type == Py.AttributeError && !(o instanceof PyInstance)) {
                throw Py.TypeError("len() of unsized object");
            }
            throw e;
        }
    }

    public static PyObject locals() {
        return Py.getFrame().getf_locals();
    }

    public static PyObject map(PyObject[] argstar) {
        int n = argstar.length - 1;
        if (n < 1) {
            throw Py.TypeError("map requires at least two arguments");
        }
        PyObject f = argstar[0];
        PyList list = new PyList();
        PyObject[] args = new PyObject[n];
        PyObject[] iters = new PyObject[n];
        for (int j = 0; j < n; ++j) {
            iters[j] = Py.iter(argstar[j + 1], "argument " + (j + 1) + " to map() must support iteration");
        }
        while (true) {
            boolean any_items = false;
            for (int j = 0; j < n; ++j) {
                PyObject element = iters[j].__iternext__();
                if (element != null) {
                    args[j] = element;
                    any_items = true;
                    continue;
                }
                args[j] = Py.None;
            }
            if (!any_items) break;
            if (f == Py.None) {
                if (n == 1) {
                    list.append(args[0]);
                    continue;
                }
                list.append(new PyTuple((PyObject[])args.clone()));
                continue;
            }
            list.append(f.__call__(args));
        }
        return list;
    }

    public static PyObject max(PyObject[] l) {
        if (l.length == 1) {
            return __builtin__.max(l[0]);
        }
        return __builtin__.max(new PyTuple(l));
    }

    private static PyObject max(PyObject o) {
        PyObject item;
        PyObject max = null;
        PyObject iter = o.__iter__();
        while ((item = iter.__iternext__()) != null) {
            if (max != null && !item._gt(max).__nonzero__()) continue;
            max = item;
        }
        if (max == null) {
            throw Py.ValueError("max of empty sequence");
        }
        return max;
    }

    public static PyObject min(PyObject[] l) {
        if (l.length == 1) {
            return __builtin__.min(l[0]);
        }
        return __builtin__.min(new PyTuple(l));
    }

    private static PyObject min(PyObject o) {
        PyObject item;
        PyObject min = null;
        PyObject iter = o.__iter__();
        while ((item = iter.__iternext__()) != null) {
            if (min != null && !item._lt(min).__nonzero__()) continue;
            min = item;
        }
        if (min == null) {
            throw Py.ValueError("min of empty sequence");
        }
        return min;
    }

    public static PyString oct(PyObject o) {
        return o.__oct__();
    }

    public static PyFile open(String name) {
        return new PyFile(name, "r", -1);
    }

    public static PyFile open(String name, String mode) {
        return new PyFile(name, mode, -1);
    }

    public static PyFile open(String name, String mode, int bufsize) {
        return new PyFile(name, mode, bufsize);
    }

    public static final int ord(char c) {
        return c;
    }

    public static PyObject pow(PyObject x, PyObject y) {
        return x._pow(y);
    }

    private static boolean coerce(PyObject[] objs) {
        PyObject x = objs[0];
        PyObject y = objs[1];
        PyObject[] result = x._coerce(y);
        if (result != null) {
            objs[0] = result[0];
            objs[1] = result[1];
            return true;
        }
        result = y._coerce(x);
        if (result != null) {
            objs[0] = result[1];
            objs[1] = result[0];
            return true;
        }
        return false;
    }

    public static PyObject pow(PyObject xi, PyObject yi, PyObject zi) {
        PyObject x = xi;
        PyObject y = yi;
        PyObject z = zi;
        PyObject[] tmp = new PyObject[]{x, y};
        if (__builtin__.coerce(tmp)) {
            x = tmp[0];
            y = tmp[1];
            tmp[1] = z;
            if (__builtin__.coerce(tmp)) {
                x = tmp[0];
                z = tmp[1];
                tmp[0] = y;
                if (__builtin__.coerce(tmp)) {
                    z = tmp[1];
                    y = tmp[0];
                }
            }
        } else {
            tmp[1] = z;
            if (__builtin__.coerce(tmp)) {
                x = tmp[0];
                z = tmp[1];
                tmp[0] = y;
                if (__builtin__.coerce(tmp)) {
                    y = tmp[0];
                    z = tmp[1];
                    tmp[1] = x;
                    if (__builtin__.coerce(tmp)) {
                        x = tmp[1];
                        y = tmp[0];
                    }
                }
            }
        }
        if (x.getType() == y.getType() && x.getType() == z.getType() && (x = x.__pow__(y, z)) != null) {
            return x;
        }
        throw Py.TypeError("__pow__ not defined for these operands");
    }

    public static PyObject range(int start, int stop, int step) {
        if (step == 0) {
            throw Py.ValueError("zero step for range()");
        }
        int n = step > 0 ? (stop - start + step - 1) / step : (stop - start + step + 1) / step;
        if (n <= 0) {
            return new PyList();
        }
        PyObject[] l = new PyObject[n];
        int j = start;
        for (int i = 0; i < n; ++i) {
            l[i] = Py.newInteger(j);
            j += step;
        }
        return new PyList(l);
    }

    public static PyObject range(int n) {
        return __builtin__.range(0, n, 1);
    }

    public static PyObject range(int start, int stop) {
        return __builtin__.range(start, stop, 1);
    }

    private static PyString readline(PyObject file) {
        if (file instanceof PyFile) {
            return new PyString(((PyFile)file).readline());
        }
        PyObject ret = file.invoke("readline");
        if (!(ret instanceof PyString)) {
            throw Py.TypeError("object.readline() returned non-string");
        }
        return (PyString)ret;
    }

    public static String raw_input(PyObject prompt) {
        Py.print(prompt);
        PyObject stdin = Py.getSystemState().stdin;
        String data = __builtin__.readline(stdin).toString();
        if (data.endsWith("\n")) {
            return data.substring(0, data.length() - 1);
        }
        if (data.length() == 0) {
            throw Py.EOFError("raw_input()");
        }
        return data;
    }

    public static String raw_input() {
        return __builtin__.raw_input(new PyString(""));
    }

    public static PyObject reduce(PyObject f, PyObject l, PyObject z) {
        PyObject item;
        PyObject result = z;
        PyObject iter = Py.iter(l, "reduce() arg 2 must support iteration");
        while ((item = iter.__iternext__()) != null) {
            if (result == null) {
                result = item;
                continue;
            }
            result = f.__call__(result, item);
        }
        if (result == null) {
            throw Py.TypeError("reduce of empty sequence with no initial value");
        }
        return result;
    }

    public static PyObject reduce(PyObject f, PyObject l) {
        return __builtin__.reduce(f, l, null);
    }

    public static PyObject reload(PyModule o) {
        return imp.reload(o);
    }

    public static PyObject reload(PyJavaClass o) {
        return imp.reload(o);
    }

    public static PyString repr(PyObject o) {
        return o.__repr__();
    }

    public static PyFloat round(double f, int digits) {
        boolean neg = f < 0.0;
        double multiple = Math.pow(10.0, digits);
        if (neg) {
            f = -f;
        }
        double tmp = Math.floor(f * multiple + 0.5);
        if (neg) {
            tmp = -tmp;
        }
        return new PyFloat(tmp / multiple);
    }

    public static PyFloat round(double f) {
        return __builtin__.round(f, 0);
    }

    public static void setattr(PyObject o, PyString n, PyObject v) {
        o.__setattr__(n, v);
    }

    public static PySlice slice(PyObject start, PyObject stop, PyObject step) {
        return new PySlice(start, stop, step);
    }

    public static PySlice slice(PyObject start, PyObject stop) {
        return __builtin__.slice(start, stop, Py.None);
    }

    public static PySlice slice(PyObject stop) {
        return __builtin__.slice(Py.None, stop, Py.None);
    }

    public static PyObject iter(PyObject obj) {
        return obj.__iter__();
    }

    public static PyObject iter(PyObject callable, PyObject sentinel) {
        return new PyCallIter(callable, sentinel);
    }

    public static PyObject sum(PyObject seq, PyObject result) {
        PyObject item;
        if (result instanceof PyString) {
            throw Py.TypeError("sum() can't sum strings [use ''.join(seq) instead]");
        }
        PyObject iter = seq.__iter__();
        while ((item = iter.__iternext__()) != null) {
            result = result._add(item);
        }
        return result;
    }

    public static PyObject sum(PyObject seq) {
        return __builtin__.sum(seq, Py.Zero);
    }

    public static PyTuple tuple(PyObject o) {
        if (o instanceof PyTuple) {
            return (PyTuple)o;
        }
        if (o instanceof PyList) {
            PyList l = (PyList)o;
            PyObject[] a = new PyObject[l.size()];
            System.arraycopy(l.getArray(), 0, a, 0, a.length);
            return new PyTuple(a);
        }
        return new PyTuple(Py.make_array(o));
    }

    public static PyType type(PyObject o) {
        return o.getType();
    }

    public static PyObject vars(PyObject o) {
        return o.__getattr__("__dict__");
    }

    public static PyObject vars() {
        return __builtin__.locals();
    }

    public static PyObject xrange(int start, int stop, int step) {
        return new PyXRange(start, stop, step);
    }

    public static PyObject xrange(int n) {
        return __builtin__.xrange(0, n, 1);
    }

    public static PyObject xrange(int start, int stop) {
        return __builtin__.xrange(start, stop, 1);
    }

    public static PyObject zip(PyObject[] argstar) {
        int itemsize = argstar.length;
        if (itemsize < 1) {
            throw Py.TypeError("zip requires at least one sequence");
        }
        PyObject[] iters = new PyObject[itemsize];
        for (int j = 0; j < itemsize; ++j) {
            PyObject iter = argstar[j].__iter__();
            if (iter == null) {
                throw Py.TypeError("zip argument #" + (j + 1) + " must support iteration");
            }
            iters[j] = iter;
        }
        PyList ret = new PyList();
        int i = 0;
        while (true) {
            PyObject[] next = new PyObject[itemsize];
            for (int j = 0; j < itemsize; ++j) {
                PyObject item;
                try {
                    item = iters[j].__iternext__();
                }
                catch (PyException e) {
                    if (Py.matchException(e, Py.StopIteration)) {
                        return ret;
                    }
                    throw e;
                }
                if (item == null) {
                    return ret;
                }
                next[j] = item;
            }
            ret.append(new PyTuple(next));
            ++i;
        }
    }

    public static PyObject __import__(String name) {
        return __builtin__.__import__(name, null, null, null);
    }

    public static PyObject __import__(String name, PyObject globals) {
        return __builtin__.__import__(name, globals, null, null);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals) {
        return __builtin__.__import__(name, globals, locals, null);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals, PyObject fromlist) {
        PyObject __import__;
        PyFrame frame = Py.getFrame();
        if (frame == null) {
            return null;
        }
        PyObject builtins = frame.f_builtins;
        if (builtins == null) {
            builtins = Py.getSystemState().builtins;
        }
        if ((__import__ = builtins.__finditem__("__import__")) == null) {
            return null;
        }
        PyObject module = __import__.__call__(new PyObject[]{Py.newString(name), globals, locals, fromlist});
        return module;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        __doc__zip = new PyString("zip(seq1 [, seq2 [...]]) -> [(seq1[0], seq2[0] ...), (...)]\n\nReturn a list of tuples, where each tuple contains the i-th element\nfrom each of the argument sequences.  The returned list is\ntruncated in length to the length of the shortest argument sequence.");
    }
}

