/*
 * Decompiled with CFR 0.152.
 */
package org.mmocore.network;

import java.nio.ByteOrder;
import org.mmocore.network.IPacketHandler;
import org.mmocore.network.MMOClient;
import org.mmocore.network.TCPHeaderHandler;
import org.mmocore.network.UDPHeaderHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorConfig<T extends MMOClient> {
    private final UDPHeaderHandler<T> UDP_HEADER_HANDLER;
    private final IPacketHandler<T> UDP_PACKET_HANDLER;
    private final TCPHeaderHandler<T> TCP_HEADER_HANDLER;
    private final IPacketHandler<T> TCP_PACKET_HANDLER;
    private int READ_BUFFER_SIZE = 65536;
    private int WRITE_BUFFER_SIZE = 65536;
    private int MAX_SEND_PER_PASS = 1;
    private int SLEEP_TIME = 10;
    private HeaderSize HEADER_TYPE = HeaderSize.SHORT_HEADER;
    private int HELPER_BUFFER_SIZE = 65536;
    private int HELPER_BUFFER_COUNT = 20;
    private ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;

    public SelectorConfig(UDPHeaderHandler<T> udpHeaderHandler, IPacketHandler<T> udpPacketHandler, TCPHeaderHandler<T> tcpHeaderHandler, IPacketHandler<T> tcpPacketHandler) {
        this.UDP_HEADER_HANDLER = udpHeaderHandler;
        this.UDP_PACKET_HANDLER = udpPacketHandler;
        this.TCP_HEADER_HANDLER = tcpHeaderHandler;
        this.TCP_PACKET_HANDLER = tcpPacketHandler;
    }

    public int getReadBufferSize() {
        return this.READ_BUFFER_SIZE;
    }

    public int getWriteBufferSize() {
        return this.READ_BUFFER_SIZE;
    }

    public int getHelperBufferSize() {
        return this.HELPER_BUFFER_SIZE;
    }

    public int getHelperBufferCount() {
        return this.HELPER_BUFFER_COUNT;
    }

    public ByteOrder getByteOrder() {
        return this.BYTE_ORDER;
    }

    public HeaderSize getHeaderType() {
        return this.HEADER_TYPE;
    }

    public UDPHeaderHandler<T> getUDPHeaderHandler() {
        return this.UDP_HEADER_HANDLER;
    }

    public IPacketHandler<T> getUDPPacketHandler() {
        return this.UDP_PACKET_HANDLER;
    }

    public TCPHeaderHandler<T> getTCPHeaderHandler() {
        return this.TCP_HEADER_HANDLER;
    }

    public IPacketHandler<T> getTCPPacketHandler() {
        return this.TCP_PACKET_HANDLER;
    }

    public void setMaxSendPerPass(int maxSendPerPass) {
        this.MAX_SEND_PER_PASS = maxSendPerPass;
    }

    public int getMaxSendPerPass() {
        return this.MAX_SEND_PER_PASS;
    }

    public void setSelectorSleepTime(int sleepTime) {
        this.SLEEP_TIME = sleepTime;
    }

    public int getSelectorSleepTime() {
        return this.SLEEP_TIME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeaderSize {
        BYTE_HEADER,
        SHORT_HEADER,
        INT_HEADER;

    }
}

