/*
 * Decompiled with CFR 0.152.
 */
package org.mmocore.network;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javolution.util.FastCollection;
import javolution.util.FastList;
import org.mmocore.network.HeaderInfo;
import org.mmocore.network.IAcceptFilter;
import org.mmocore.network.IClientFactory;
import org.mmocore.network.IMMOExecutor;
import org.mmocore.network.IPacketHandler;
import org.mmocore.network.MMOClient;
import org.mmocore.network.MMOConnection;
import org.mmocore.network.ReceivablePacket;
import org.mmocore.network.SelectorConfig;
import org.mmocore.network.SendablePacket;
import org.mmocore.network.TCPHeaderHandler;
import org.mmocore.network.TCPSocket;
import org.mmocore.network.UDPHeaderHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorThread<T extends MMOClient>
extends Thread {
    private Selector _selector;
    private final IPacketHandler<T> _packetHandler;
    private final IPacketHandler<T> _udpPacketHandler;
    private IMMOExecutor<T> _executor;
    private IClientFactory<T> _clientFactory;
    private IAcceptFilter _acceptFilter;
    private final UDPHeaderHandler<T> _udpHeaderHandler;
    private final TCPHeaderHandler<T> _tcpHeaderHandler;
    private boolean _shutdown;
    private FastList<MMOConnection<T>> _pendingClose = new FastList();
    private final int HELPER_BUFFER_SIZE;
    private final int HELPER_BUFFER_COUNT;
    private final int MAX_SEND_PER_PASS;
    private int HEADER_SIZE = 2;
    private final ByteOrder BYTE_ORDER;
    private final long SLEEP_TIME;
    private final ByteBuffer DIRECT_WRITE_BUFFER;
    private final ByteBuffer WRITE_BUFFER;
    private final ByteBuffer READ_BUFFER;
    private final FastList<ByteBuffer> _bufferPool = new FastList();

    public SelectorThread(SelectorConfig<T> sc, IMMOExecutor<T> executor, IClientFactory<T> clientFactory, IAcceptFilter acceptFilter) throws IOException {
        this.HELPER_BUFFER_SIZE = sc.getHelperBufferSize();
        this.HELPER_BUFFER_COUNT = sc.getHelperBufferCount();
        this.MAX_SEND_PER_PASS = sc.getMaxSendPerPass();
        this.BYTE_ORDER = sc.getByteOrder();
        this.SLEEP_TIME = sc.getSelectorSleepTime();
        this.DIRECT_WRITE_BUFFER = ByteBuffer.allocateDirect(sc.getWriteBufferSize()).order(this.BYTE_ORDER);
        this.WRITE_BUFFER = ByteBuffer.wrap(new byte[sc.getWriteBufferSize()]).order(this.BYTE_ORDER);
        this.READ_BUFFER = ByteBuffer.wrap(new byte[sc.getReadBufferSize()]).order(this.BYTE_ORDER);
        this._udpHeaderHandler = sc.getUDPHeaderHandler();
        this._tcpHeaderHandler = sc.getTCPHeaderHandler();
        this.initBufferPool();
        this._acceptFilter = acceptFilter;
        this._packetHandler = sc.getTCPPacketHandler();
        this._udpPacketHandler = sc.getUDPPacketHandler();
        this._clientFactory = clientFactory;
        this.setExecutor(executor);
        this.initializeSelector();
    }

    protected void initBufferPool() {
        for (int i = 0; i < this.HELPER_BUFFER_COUNT; ++i) {
            this.getFreeBuffers().addLast(ByteBuffer.wrap(new byte[this.HELPER_BUFFER_SIZE]).order(this.BYTE_ORDER));
        }
    }

    public void openServerSocket(InetAddress address, int tcpPort) throws IOException {
        ServerSocketChannel selectable = ServerSocketChannel.open();
        selectable.configureBlocking(false);
        ServerSocket ss = selectable.socket();
        if (address == null) {
            ss.bind(new InetSocketAddress(tcpPort));
        } else {
            ss.bind(new InetSocketAddress(address, tcpPort));
        }
        selectable.register(this.getSelector(), 16);
    }

    public void openDatagramSocket(InetAddress address, int udpPort) throws IOException {
        DatagramChannel selectable = DatagramChannel.open();
        selectable.configureBlocking(false);
        DatagramSocket ss = selectable.socket();
        if (address == null) {
            ss.bind(new InetSocketAddress(udpPort));
        } else {
            ss.bind(new InetSocketAddress(address, udpPort));
        }
        selectable.register(this.getSelector(), 1);
    }

    protected void initializeSelector() throws IOException {
        this.setName("SelectorThread-" + this.getId());
        this.setSelector(Selector.open());
    }

    protected ByteBuffer getPooledBuffer() {
        if (this.getFreeBuffers().isEmpty()) {
            return ByteBuffer.wrap(new byte[this.HELPER_BUFFER_SIZE]).order(this.BYTE_ORDER);
        }
        return this.getFreeBuffers().removeFirst();
    }

    public void recycleBuffer(ByteBuffer buf) {
        if (this.getFreeBuffers().size() < this.HELPER_BUFFER_COUNT) {
            buf.clear();
            this.getFreeBuffers().addLast(buf);
        }
    }

    public FastList<ByteBuffer> getFreeBuffers() {
        return this._bufferPool;
    }

    public SelectionKey registerClientSocket(SelectableChannel sc, int interestOps) throws ClosedChannelException {
        SelectionKey sk = null;
        sk = sc.register(this.getSelector(), interestOps);
        return sk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int totalKeys = 0;
        while (true) {
            Collection<Object> keys;
            if (this.isShuttingDown()) break;
            try {
                totalKeys = this.getSelector().selectNow();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (totalKeys > 0) {
                keys = this.getSelector().selectedKeys();
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = (SelectionKey)iter.next();
                    iter.remove();
                    switch (key.readyOps()) {
                        case 8: {
                            this.finishConnection(key);
                            break;
                        }
                        case 16: {
                            this.acceptConnection(key);
                            break;
                        }
                        case 1: {
                            this.readPacket(key);
                            break;
                        }
                        case 4: {
                            this.writePacket2(key);
                            break;
                        }
                        case 5: {
                            this.writePacket2(key);
                            if (!key.isValid()) break;
                            this.readPacket(key);
                        }
                    }
                }
            }
            keys = this.getPendingClose();
            synchronized (keys) {
                FastCollection.Record n = this.getPendingClose().head();
                FastCollection.Record end = this.getPendingClose().tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    MMOConnection con = (MMOConnection)((FastList.Node)n).getValue();
                    if (!con.getSendQueue().isEmpty()) continue;
                    FastCollection.Record temp = ((FastList.Node)n).getPrevious();
                    this.getPendingClose().delete(n);
                    n = temp;
                    this.closeConnectionImpl(con);
                }
            }
            try {
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.closeSelectorThread();
    }

    protected void finishConnection(SelectionKey key) {
        try {
            ((SocketChannel)key.channel()).finishConnect();
        }
        catch (IOException e) {
            MMOConnection con = (MMOConnection)key.attachment();
            Object client = con.getClient();
            ((MMOConnection)((MMOClient)client).getConnection()).onForcedDisconnection();
            this.closeConnectionImpl((MMOConnection<T>)((MMOClient)client).getConnection());
        }
        if (key.isValid()) {
            key.interestOps(key.interestOps() | 1);
            key.interestOps(key.interestOps() & 0xFFFFFFF7);
        }
    }

    protected void acceptConnection(SelectionKey key) {
        try {
            SocketChannel sc;
            while ((sc = ((ServerSocketChannel)key.channel()).accept()) != null) {
                if (this.getAcceptFilter() == null || this.getAcceptFilter().accept(sc)) {
                    sc.configureBlocking(false);
                    SelectionKey clientKey = sc.register(this.getSelector(), 1);
                    MMOConnection con = new MMOConnection(this, new TCPSocket(sc.socket()), clientKey);
                    T client = this.getClientFactory().create(con);
                    clientKey.attach(con);
                    continue;
                }
                sc.socket().close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void readPacket(SelectionKey key) {
        if (key.channel() instanceof SocketChannel) {
            this.readTCPPacket(key);
        } else {
            this.readUDPPacket(key);
        }
    }

    protected void readTCPPacket(SelectionKey key) {
        MMOConnection con = (MMOConnection)key.attachment();
        Object client = con.getClient();
        ByteBuffer buf = con.getReadBuffer();
        if (buf == null) {
            buf = this.READ_BUFFER;
        }
        int result = -2;
        if (buf.position() == buf.limit()) {
            System.err.println("POS ANTES SC.READ(): " + buf.position() + " limit: " + buf.limit());
            System.err.println("NOOBISH ERROR " + (buf == this.READ_BUFFER ? "READ_BUFFER" : "temp"));
            System.exit(0);
        }
        try {
            result = con.getReadableByteChannel().read(buf);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (result > 0) {
            if (!con.isClosed()) {
                buf.flip();
                while (this.tryReadPacket2(key, client, buf)) {
                }
            } else if (buf == this.READ_BUFFER) {
                this.READ_BUFFER.clear();
            }
        } else if (result == 0) {
            System.out.println("NOOBISH ERROR 2 THE MISSION");
            System.exit(0);
        } else if (result == -1) {
            this.closeConnectionImpl(con);
        } else {
            con.onForcedDisconnection();
            this.closeConnectionImpl(con);
        }
    }

    protected void readUDPPacket(SelectionKey key) {
        int result = -2;
        ByteBuffer buf = this.READ_BUFFER;
        DatagramChannel dc = (DatagramChannel)key.channel();
        if (!dc.isConnected()) {
            try {
                dc.configureBlocking(false);
                SocketAddress address = dc.receive(buf);
                buf.flip();
                this._udpHeaderHandler.onUDPConnection(this, dc, address, buf);
            }
            catch (IOException e) {
                // empty catch block
            }
            buf.clear();
        } else {
            try {
                result = dc.read(buf);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (result > 0) {
                buf.flip();
                while (this.tryReadUDPPacket(key, buf)) {
                }
            } else if (result == 0) {
                System.out.println("CRITICAL ERROR ON SELECTOR");
                System.exit(0);
            }
        }
    }

    protected boolean tryReadPacket2(SelectionKey key, T client, ByteBuffer buf) {
        Object con = ((MMOClient)client).getConnection();
        if (buf.hasRemaining()) {
            TCPHeaderHandler handler = this._tcpHeaderHandler;
            while (!handler.isChildHeaderHandler()) {
                handler.handleHeader(key, buf);
                handler = (TCPHeaderHandler)handler.getSubHeaderHandler();
            }
            HeaderInfo ret = handler.handleHeader(key, buf);
            if (ret != null) {
                int result = buf.remaining();
                if (ret.headerFinished()) {
                    int size = ret.getDataPending();
                    if (size <= result) {
                        if (size > 0) {
                            int pos = buf.position();
                            this.parseClientPacket(this.getPacketHandler(), buf, size, client);
                            buf.position(pos + size);
                        }
                        if (!buf.hasRemaining()) {
                            if (buf != this.READ_BUFFER) {
                                ((MMOConnection)con).setReadBuffer(null);
                                this.recycleBuffer(buf);
                            } else {
                                this.READ_BUFFER.clear();
                            }
                            return false;
                        }
                        return true;
                    }
                    ((MMOConnection)((MMOClient)client).getConnection()).enableReadInterest();
                    if (buf == this.READ_BUFFER) {
                        buf.position(buf.position() - this.HEADER_SIZE);
                        this.allocateReadBuffer((MMOConnection)con);
                    } else {
                        buf.position(buf.position() - this.HEADER_SIZE);
                        buf.compact();
                    }
                    return false;
                }
                ((MMOConnection)((MMOClient)client).getConnection()).enableReadInterest();
                if (buf == this.READ_BUFFER) {
                    this.allocateReadBuffer((MMOConnection)con);
                } else {
                    buf.compact();
                }
                return false;
            }
            this.closeConnectionImpl((MMOConnection<T>)con);
            return false;
        }
        return false;
    }

    protected boolean tryReadUDPPacket(SelectionKey key, ByteBuffer buf) {
        if (buf.hasRemaining()) {
            UDPHeaderHandler handler = this._udpHeaderHandler;
            while (!handler.isChildHeaderHandler()) {
                handler.handleHeader(buf);
                handler = (UDPHeaderHandler)handler.getSubHeaderHandler();
            }
            HeaderInfo ret = handler.handleHeader(buf);
            if (ret != null) {
                int result = buf.remaining();
                if (ret.headerFinished()) {
                    MMOClient client = (MMOClient)ret.getClient();
                    Object con = client.getConnection();
                    int size = ret.getDataPending();
                    if (size <= result) {
                        if (ret.isMultiPacket()) {
                            while (buf.hasRemaining()) {
                                this.parseClientPacket(this._udpPacketHandler, buf, buf.remaining(), client);
                            }
                        } else if (size > 0) {
                            int pos = buf.position();
                            this.parseClientPacket(this._udpPacketHandler, buf, size, client);
                            buf.position(pos + size);
                        }
                        if (!buf.hasRemaining()) {
                            if (buf != this.READ_BUFFER) {
                                ((MMOConnection)con).setReadBuffer(null);
                                this.recycleBuffer(buf);
                            } else {
                                this.READ_BUFFER.clear();
                            }
                            return false;
                        }
                        return true;
                    }
                    ((MMOConnection)client.getConnection()).enableReadInterest();
                    if (buf == this.READ_BUFFER) {
                        buf.position(buf.position() - this.HEADER_SIZE);
                        this.allocateReadBuffer((MMOConnection)con);
                    } else {
                        buf.position(buf.position() - this.HEADER_SIZE);
                        buf.compact();
                    }
                    return false;
                }
                buf.clear();
                return false;
            }
            buf.clear();
            return false;
        }
        buf.clear();
        return false;
    }

    protected void allocateReadBuffer(MMOConnection con) {
        con.setReadBuffer(this.getPooledBuffer().put(this.READ_BUFFER));
        this.READ_BUFFER.clear();
    }

    protected void parseClientPacket(IPacketHandler<T> handler, ByteBuffer buf, int dataSize, T client) {
        int pos = buf.position();
        boolean ret = ((MMOClient)client).decrypt(buf, dataSize);
        buf.position(pos);
        if (buf.hasRemaining() && ret) {
            int limit = buf.limit();
            buf.limit(pos + dataSize);
            ReceivablePacket<T> cp = handler.handlePacket(buf, client);
            if (cp != null) {
                cp.setByteBuffer(buf);
                cp.setClient(client);
                if (cp.read()) {
                    this.getExecutor().execute(cp);
                }
            }
            buf.limit(limit);
        }
    }

    protected void prepareWriteBuffer(T client, SendablePacket<T> sp) {
        this.WRITE_BUFFER.clear();
        sp.setByteBuffer(this.WRITE_BUFFER);
        int headerPos = sp.getByteBuffer().position();
        int headerSize = sp.getHeaderSize();
        sp.getByteBuffer().position(headerPos + headerSize);
        sp.write();
        int dataSize = sp.getByteBuffer().position() - headerPos - headerSize;
        sp.getByteBuffer().position(headerPos + headerSize);
        ((MMOClient)client).encrypt(sp.getByteBuffer(), dataSize);
        sp.writeHeader(dataSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePacket2(SelectionKey key) {
        MMOConnection con = (MMOConnection)key.attachment();
        Object client = con.getClient();
        this.prepareWriteBuffer2(con);
        this.DIRECT_WRITE_BUFFER.flip();
        int size = this.DIRECT_WRITE_BUFFER.remaining();
        int result = -1;
        try {
            result = con.getWritableChannel().write(this.DIRECT_WRITE_BUFFER);
        }
        catch (IOException e) {
            System.err.println("IOError: " + e.getMessage());
        }
        if (result >= 0) {
            if (result == size) {
                FastList fastList = con.getSendQueue();
                synchronized (fastList) {
                    if (con.getSendQueue().isEmpty() && !con.hasPendingWriteBuffer()) {
                        con.disableWriteInterest();
                    }
                }
            } else {
                con.createWriteBuffer(this.DIRECT_WRITE_BUFFER);
            }
            if (result == 0) {
                // empty if block
            }
        } else {
            con.onForcedDisconnection();
            this.closeConnectionImpl(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareWriteBuffer2(MMOConnection<T> con) {
        this.DIRECT_WRITE_BUFFER.clear();
        if (con.hasPendingWriteBuffer()) {
            con.movePendingWriteBufferTo(this.DIRECT_WRITE_BUFFER);
        }
        if (this.DIRECT_WRITE_BUFFER.remaining() > 1 && !con.hasPendingWriteBuffer()) {
            FastList<SendablePacket<T>> sendQueue;
            int i = 0;
            FastList<SendablePacket<T>> fastList = sendQueue = con.getSendQueue();
            synchronized (fastList) {
                FastCollection.Record n = sendQueue.head();
                FastCollection.Record end = sendQueue.tail();
                while ((n = ((FastList.Node)n).getNext()) != end && i++ < this.MAX_SEND_PER_PASS) {
                    SendablePacket sp = (SendablePacket)((FastList.Node)n).getValue();
                    this.putPacketIntoWriteBuffer(con.getClient(), sp);
                    FastCollection.Record temp = ((FastList.Node)n).getPrevious();
                    sendQueue.delete(n);
                    n = temp;
                    this.WRITE_BUFFER.flip();
                    if (this.DIRECT_WRITE_BUFFER.remaining() >= this.WRITE_BUFFER.limit()) {
                        this.DIRECT_WRITE_BUFFER.put(this.WRITE_BUFFER);
                        continue;
                    }
                    con.createWriteBuffer(this.WRITE_BUFFER);
                    break;
                }
            }
        }
    }

    protected final void putPacketIntoWriteBuffer(T client, SendablePacket<T> sp) {
        this.WRITE_BUFFER.clear();
        sp.setByteBuffer(this.WRITE_BUFFER);
        int headerPos = sp.getByteBuffer().position();
        int headerSize = sp.getHeaderSize();
        sp.getByteBuffer().position(headerPos + headerSize);
        sp.write();
        int dataSize = sp.getByteBuffer().position() - headerPos - headerSize;
        sp.getByteBuffer().position(headerPos + headerSize);
        ((MMOClient)client).encrypt(sp.getByteBuffer(), dataSize);
        dataSize = sp.getByteBuffer().position() - headerPos - headerSize;
        sp.getByteBuffer().position(headerPos);
        sp.writeHeader(dataSize);
        sp.getByteBuffer().position(headerPos + headerSize + dataSize);
    }

    protected void setSelector(Selector selector) {
        this._selector = selector;
    }

    public Selector getSelector() {
        return this._selector;
    }

    protected void setExecutor(IMMOExecutor<T> executor) {
        this._executor = executor;
    }

    protected IMMOExecutor<T> getExecutor() {
        return this._executor;
    }

    public IPacketHandler<T> getPacketHandler() {
        return this._packetHandler;
    }

    protected void setClientFactory(IClientFactory<T> clientFactory) {
        this._clientFactory = clientFactory;
    }

    public IClientFactory<T> getClientFactory() {
        return this._clientFactory;
    }

    public void setAcceptFilter(IAcceptFilter acceptFilter) {
        this._acceptFilter = acceptFilter;
    }

    public IAcceptFilter getAcceptFilter() {
        return this._acceptFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(MMOConnection<T> con) {
        FastList<MMOConnection<T>> fastList = this.getPendingClose();
        synchronized (fastList) {
            this.getPendingClose().addLast(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnectionImpl(MMOConnection<T> con) {
        try {
            con.onDisconnection();
        }
        finally {
            try {
                con.getSocket().close();
            }
            catch (IOException iOException) {
            }
            finally {
                con.releaseBuffers();
                con.getSelectionKey().attach(null);
                con.getSelectionKey().cancel();
            }
        }
    }

    protected FastList<MMOConnection<T>> getPendingClose() {
        return this._pendingClose;
    }

    public void shutdown() {
        this._shutdown = true;
    }

    public boolean isShuttingDown() {
        return this._shutdown;
    }

    protected void closeAllChannels() {
        Set<SelectionKey> keys = this.getSelector().keys();
        for (SelectionKey key : keys) {
            try {
                key.channel().close();
            }
            catch (IOException e) {}
        }
    }

    protected void closeSelectorThread() {
        this.closeAllChannels();
        try {
            this.getSelector().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

