/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/gpl.html
 */
package net.sf.l2j.gameserver.instancemanager.lastimperialtomb;

import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Logger;

import javolution.util.FastList;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.datatables.DoorTable;
import net.sf.l2j.gameserver.instancemanager.GrandBossManager;
import net.sf.l2j.gameserver.instancemanager.lastimperialtomb.FrintezzaManager;
import net.sf.l2j.gameserver.instancemanager.lastimperialtomb.LastImperialTombSpawnlist;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.L2Party;
import net.sf.l2j.gameserver.model.actor.instance.L2DoorInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2NpcInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.serverpackets.CreatureSay;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.util.Rnd;

/**
 *
 * @author  L2J_JP SANDMAN
 */
public class LastImperialTombManager
{
    private static Logger _log = Logger.getLogger(LastImperialTombManager.class.getName());

    private static LastImperialTombManager _instance = null;

    private static boolean _IsInvaded = false;

    // instance list of monsters.
    protected static List<L2NpcInstance> _HallAlarmDevices = new FastList<L2NpcInstance>();
    protected static List<L2NpcInstance> _DarkChoirPlayers = new FastList<L2NpcInstance>();
    protected static List<L2NpcInstance> _DarkChoirCaptains = new FastList<L2NpcInstance>();
    protected static List<L2NpcInstance> _Room1Monsters = new FastList<L2NpcInstance>();
    protected static List<L2NpcInstance> _Room2InsideMonsters = new FastList<L2NpcInstance>();
    protected static List<L2NpcInstance> _Room2OutsideMonsters = new FastList<L2NpcInstance>();

    // instance list of doors.
    protected static List<L2DoorInstance> _Room1Doors = new FastList<L2DoorInstance>();
    protected static List<L2DoorInstance> _Room2InsideDoors = new FastList<L2DoorInstance>();
    protected static List<L2DoorInstance> _Room2OutsideDoors = new FastList<L2DoorInstance>();
    protected static L2DoorInstance _Room3Door = null;

    // instance list of players.
    protected static List<L2PcInstance> _PlayersInLair = new FastList<L2PcInstance>();
    protected static List<L2PcInstance> _PartyLeaders = new FastList<L2PcInstance>();
    protected static List<L2PcInstance> _RegistedPlayers = new FastList<L2PcInstance>();
    protected static L2PcInstance _Commander = null;

    // Frintezza's Magic Force Field Removal Scroll.
    private final int _ScrollId = 8073;

    // status in lair.
    protected String _ZoneType = "LastImperialTomb";
    protected final String _QuestName = "lastimperialtomb";

    // player does reach to HallofFrintezza
    private boolean _IsReachToHall = false;

    // location of invade.
    private final int[][] _InvadeLoc =
    	{
    		{173235,-76884,-5107},
    		{175003,-76933,-5107},
    		{174196,-76190,-5107},
    		{174013,-76120,-5107},
    		{173263,-75161,-5107}
    	};

	// location of banishment.
	private final int[][] _BanishmentLocation =
		{
			{147675, -55669, -2768},
			{150654, -56210, -2980},
			{147936, -58437, -2980},
			{144839, -56479, -2980}
		};

	// task
    protected ScheduledFuture<?> _InvadeTask = null;
    protected ScheduledFuture<?> _RegistrationTimeInfoTask = null;
    protected ScheduledFuture<?> _Room1SpawnTask = null;
    protected ScheduledFuture<?> _Room2InsideDoorOpenTask = null;
    protected ScheduledFuture<?> _Room2OutsideSpawnTask = null;
    protected ScheduledFuture<?> _CheckTimeUpTask = null;
    protected ScheduledFuture<?> _OnPlayersAnnihilatedTask = null;

    // Constructor
    public LastImperialTombManager()
    {

    }

    // instance.
    public static LastImperialTombManager getInstance()
    {
    	if(_instance == null)
    		_instance = new LastImperialTombManager();

    	return _instance;
    }

    // load monsters and close doors.
    public void init()
    {
    	LastImperialTombSpawnlist.getInstance().clear();
    	LastImperialTombSpawnlist.getInstance().fill();
    	this.initDoors();

    	_log.info("LastImperialTombManager: Init The Last Imperial Tomb.");
    }

    // setting list of doors and close doors.
    private void initDoors()
    {
    	_Room1Doors.clear();
    	_Room1Doors.add(DoorTable.getInstance().getDoor(25150042));

    	for(int i = 25150051;i <= 25150058;i++)
    	{
    		_Room1Doors.add(DoorTable.getInstance().getDoor(i));
    	}

    	_Room2InsideDoors.clear();
    	for(int i = 25150061;i <= 25150070;i++)
    	{
    		_Room2InsideDoors.add(DoorTable.getInstance().getDoor(i));
    	}
    	_Room2OutsideDoors.clear();
    	_Room2OutsideDoors.add(DoorTable.getInstance().getDoor(25150043));
    	_Room2OutsideDoors.add(DoorTable.getInstance().getDoor(25150045));

    	_Room3Door = DoorTable.getInstance().getDoor(25150046);

    	for(L2DoorInstance door : _Room1Doors)
    	{
    		door.closeMe();
    	}

    	for(L2DoorInstance door : _Room2InsideDoors)
    	{
    		door.closeMe();
    	}

    	for(L2DoorInstance door : _Room2OutsideDoors)
    	{
    		door.closeMe();
    	}

    	_Room3Door.closeMe();
    }

    // return true,tomb was already invaded by players.
    public boolean isInvaded()
    {
    	return _IsInvaded;
    }

    public boolean isReachToHall()
    {
    	return _IsReachToHall;
    }

    // RegisirationMode = command channel.
    public boolean tryRegistrationCc(L2PcInstance pc)
    {
    	if(!FrintezzaManager.getInstance().isEnableEnterToLair())
    		return false;

    	if (isInvaded())
    		return false;

    	if(_Commander == null)
	    	if(pc.getParty() != null)
	    		if(pc.getParty().getCommandChannel() != null)
	    			if((pc.getParty().getCommandChannel().getChannelLeader().equals(pc)) &&
	    				(pc.getParty().getCommandChannel().getPartys().size() >= Config.LIT_MIN_PARTY_CNT) &&
	    				(pc.getParty().getCommandChannel().getPartys().size() <= Config.LIT_MAX_PARTY_CNT) &&
	    				(pc.getInventory().getInventoryItemCount(_ScrollId, -1) >= 1))
	    				return true;

    	return false;
    }

    // RegisirationMode = party.
    public boolean tryRegistrationPt(L2PcInstance pc)
    {
    	if(!FrintezzaManager.getInstance().isEnableEnterToLair())
    		return false;

    	if (isInvaded())
    		return false;

    	if(_PartyLeaders.size() < Config.LIT_MAX_PARTY_CNT)
	    	if(pc.getParty() != null)
	    		if((pc.getParty().getLeader().equals(pc)) && (pc.getInventory().getInventoryItemCount(_ScrollId, -1) >= 1))
	   	    		return true;

    	return false;
    }

    // RegisirationMode = single.
    public boolean tryRegistrationPc(L2PcInstance pc)
    {
    	if(!FrintezzaManager.getInstance().isEnableEnterToLair())
    		return false;

    	if (isInvaded())
    		return false;

    	if(_RegistedPlayers.size() < Config.LIT_MAX_PLAYER_CNT)
	    	if(pc.getInventory().getInventoryItemCount(_ScrollId, -1) >= 1)
	    		return true;

    	return false;
    }

    // registration to enter to tomb.
    public synchronized void registration(L2PcInstance pc,L2NpcInstance npc)
    {
    	switch(Config.LIT_REGISTRATION_MODE)
    	{
    	case 0:
    		if(_Commander != null) return;
    		_Commander = pc;
    		if(_InvadeTask != null)
    			_InvadeTask.cancel(true);
    		_InvadeTask =
    			ThreadPoolManager.getInstance().scheduleGeneral(new Invade(),10000);
    		break;
    	case 1:
    		if(_PartyLeaders.contains(pc)) return;
    		_PartyLeaders.add(pc);

    		if(_PartyLeaders.size() == 1)
    			_RegistrationTimeInfoTask =
    				ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc,Config.LIT_REGISTRATION_TIME * 60000),1000);
    		break;
    	case 2:
    		if(_RegistedPlayers.contains(pc)) return;
    		_RegistedPlayers.add(pc);
    		if(_RegistedPlayers.size() == 1)
    			_RegistrationTimeInfoTask =
    				ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc,Config.LIT_REGISTRATION_TIME * 60000),1000);
    		break;
    	default:
    		_log.warning("LastImperialTombManager: Invalid Registration Mode!");
    		return;
    	}
    }

    // announcement of remaining time of registration to players.
    protected void doAnnouncementRegstrationInfo(L2NpcInstance npc,int remaining)
    {
		CreatureSay cs = null;

		if(remaining == (Config.LIT_REGISTRATION_TIME * 60000))
		{
        	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"tebTľEւ̓tJn܂B");
        	//cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"It begins the reception of the entry.");
        	npc.broadcastPacket(cs);
		}

		if(remaining >= 10000)
		{
        	if(remaining > 60000)
        	{
            	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"tebTľEtI܂ŁA " + remaining / 60000 + "łB");
            	//cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"It is left until the reception ends and it is " + remaining / 60000 + " minutes.");
            	npc.broadcastPacket(cs);
        		remaining = remaining - 60000;

        		switch(Config.LIT_REGISTRATION_MODE)
            	{
            	case 1:
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"Œp[eB " + Config.LIT_MIN_PARTY_CNT);
                	npc.broadcastPacket(cs);
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"őp[eB " + Config.LIT_MAX_PARTY_CNT);
                	npc.broadcastPacket(cs);
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName()," " + _PartyLeaders.size() + " g̃p[eBo^ς݂łB");
                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of the parties which are necessary to enter is " + Config.LIT_MIN_PARTY_CNT + ".");
//                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of the party for which it is possible to enter is " + Config.LIT_MAX_PARTY_CNT + " in the maximum.");
//                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of the registered parties is " + _PartyLeaders.size() + ".");
//                	npc.broadcastPacket(cs);
            		break;
            	case 2:
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"ŒҐ " + Config.LIT_MIN_PLAYER_CNT);
                	npc.broadcastPacket(cs);
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"őҐ " + Config.LIT_MAX_PLAYER_CNT);
                	npc.broadcastPacket(cs);
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName()," " + _RegistedPlayers.size() + " o^ς݂łB");
                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of people which is necessary to enter is " + Config.LIT_MIN_PLAYER_CNT + ".");
//                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of people for which it is possible to enter is " + Config.LIT_MAX_PLAYER_CNT + " in the maximum.");
//                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The subscribed number of people is " + _RegistedPlayers.size() + " .");
//                	npc.broadcastPacket(cs);
            		break;
            	}

            	if(_RegistrationTimeInfoTask != null)
            		_RegistrationTimeInfoTask.cancel(true);
            	_RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc,remaining),60000);
        	}
        	else
        	{
            	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"tebTľEtI܂ŁA " + remaining / 1000 + "błB");
            	//cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"It is left until the reception ends and it is " + remaining / 60000 + " seconds.");
            	npc.broadcastPacket(cs);
        		remaining = remaining - 10000;

            	switch(Config.LIT_REGISTRATION_MODE)
            	{
            	case 1:
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"Œp[eB " + Config.LIT_MIN_PARTY_CNT);
                	npc.broadcastPacket(cs);
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"őp[eB " + Config.LIT_MAX_PARTY_CNT);
                	npc.broadcastPacket(cs);
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName()," " + _PartyLeaders.size() + " g̃p[eBo^ς݂łB");
                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of the parties which are necessary to enter is " + Config.LIT_MIN_PARTY_CNT + ".");
//                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of the party for which it is possible to enter is " + Config.LIT_MAX_PARTY_CNT + " in the maximum.");
//                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of the registered parties is " + _PartyLeaders.size() + ".");
//                	npc.broadcastPacket(cs);
            		break;
            	case 2:
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"ŒҐ " + Config.LIT_MIN_PLAYER_CNT);
                	npc.broadcastPacket(cs);
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"őҐ " + Config.LIT_MAX_PLAYER_CNT);
                	npc.broadcastPacket(cs);
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName()," " + _RegistedPlayers.size() + " o^ς݂łB");
                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of people which is necessary to enter is " + Config.LIT_MIN_PLAYER_CNT + ".");
//                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The number of people for which it is possible to enter is " + Config.LIT_MAX_PLAYER_CNT + " in the maximum.");
//                	npc.broadcastPacket(cs);
//                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"The subscribed number of people is " + _RegistedPlayers.size() + " .");
//                	npc.broadcastPacket(cs);
            		break;
            	}

            	if(_RegistrationTimeInfoTask != null)
            		_RegistrationTimeInfoTask.cancel(true);
            	_RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc,remaining),10000);
        	}
		}
		else
		{
        	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"tebTľEւ̓tI܂B");
        	//cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"It ended the reception of the entry.");
        	npc.broadcastPacket(cs);

        	switch(Config.LIT_REGISTRATION_MODE)
        	{
        	case 1:
        		if((_PartyLeaders.size() < Config.LIT_MIN_PARTY_CNT) || (_PartyLeaders.size() > Config.LIT_MAX_PARTY_CNT))
        		{
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"g̏𖞂Ȃ߁AꂪLZ܂B");
                	//cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"Because it isn't possible to have met the condition of the attendance, an entry was canceled.");
                	npc.broadcastPacket(cs);
                	return;
        		}
        		break;
        	case 2:
        		if((_RegistedPlayers.size() < Config.LIT_MIN_PLAYER_CNT) || (_RegistedPlayers.size() > Config.LIT_MAX_PLAYER_CNT))
        		{
                	cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"Ґ̏𖞂Ȃ߁AꂪLZ܂B");
                	//cs = new CreatureSay(npc.getObjectId(),1,npc.getName(),"Because it isn't possible to have met the condition of the attendance, an entry was canceled.");
                	npc.broadcastPacket(cs);
                	return;
        		}
        		break;
        	}

        	if(_RegistrationTimeInfoTask != null)
        		_RegistrationTimeInfoTask.cancel(true);

        	if(_InvadeTask != null)
    			_InvadeTask.cancel(true);
        	_InvadeTask =
    			ThreadPoolManager.getInstance().scheduleGeneral(new Invade(),10000);
		}
    }

    // invade to tomb.
    public void doInvade()
    {
    	initDoors();

    	switch(Config.LIT_REGISTRATION_MODE)
    	{
    	case 0:
    		doInvadeCc();
    		break;
    	case 1:
    		doInvadePt();
    		break;
    	case 2:
    		doInvadePc();
    		break;
    	default:
    		_log.warning("LastImperialTombManager: Invalid Registration Mode!");
    		return;
    	}

    	_IsInvaded = true;

    	if(_Room1SpawnTask != null)
			_Room1SpawnTask.cancel(true);
		_Room1SpawnTask =
			ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs1st(),15000);

		if(_CheckTimeUpTask != null)
			_CheckTimeUpTask.cancel(true);
		_CheckTimeUpTask =
			ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(Config.LIT_TIME_LIMIT * 60000),15000);
    }

    // return list of intruders.
    public List<L2PcInstance> getPlayersInLair()
	{
    	for(L2PcInstance pc : _PlayersInLair)
    	{
    		if(!GrandBossManager.getInstance().checkIfInZone(_ZoneType, pc))
    		{
    			_PlayersInLair.remove(pc);
    		}
    	}
		return _PlayersInLair;
	}

    // invade to tomb. when registration mode is command channel.
    private void doInvadeCc()
    {
    	int locId = 0;

    	if(_Commander.getInventory().getInventoryItemCount(_ScrollId, -1) < 1)
    	{
			SystemMessage sm = new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
			_Commander.sendPacket(sm);
			_Commander.sendMessage("𖞂ĂȂ߁Aꂪۂ܂B");
			return;
    	}
    	else
    	{
    		_Commander.destroyItemByItemId("Quest", _ScrollId, 1, _Commander, true);
    	}

    	_PlayersInLair.clear();

    	for(L2Party pt : _Commander.getParty().getCommandChannel().getPartys())
    	{
    		if(locId >= 5) locId = 0;

    		for(L2PcInstance pc : pt.getPartyMembers())
    		{
    			pc.teleToLocation(_InvadeLoc[locId][0] + Rnd.get(50), _InvadeLoc[locId][1] + Rnd.get(50), _InvadeLoc[locId][2]);
    			_PlayersInLair.add(pc);
    		}

    		locId++;
    	}
    }

    // invade to tomb. when registration mode is party.
    private void doInvadePt()
    {
    	int locId = 0;
    	boolean isReadyToInvade = true;

    	for(L2PcInstance ptl : _PartyLeaders)
    	{
        	if(ptl.getInventory().getInventoryItemCount(_ScrollId, -1) < 1)
        	{
    			SystemMessage sm = new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
    			ptl.sendPacket(sm);
    			ptl.sendMessage("𖞂ĂȂ߁Aꂪۂ܂B");
    			isReadyToInvade = false;
    		}
    	}

    	if(!isReadyToInvade)
    	{
        	for(L2PcInstance ptl : _PartyLeaders)
        	{
    			ptl.sendMessage("𖞂ĂȂp[eB邽߁Aꂪۂ܂B");
        	}
    		return;
    	}

    	for(L2PcInstance ptl : _PartyLeaders)
    	{
    		ptl.destroyItemByItemId("Quest", _ScrollId, 1, _Commander, true);
    	}

    	_PlayersInLair.clear();

    	for(L2PcInstance ptl : _PartyLeaders)
    	{
    		if(locId >= 5) locId = 0;

    		for(L2PcInstance pc : ptl.getParty().getPartyMembers())
    		{
    			pc.teleToLocation(_InvadeLoc[locId][0] + Rnd.get(50), _InvadeLoc[locId][1] + Rnd.get(50), _InvadeLoc[locId][2]);
    			_PlayersInLair.add(pc);
    		}

    		locId++;
    	}
    }

    // invade to tomb. when registration mode is single.
    private void doInvadePc()
    {
    	int locId = 0;
    	boolean isReadyToInvade = true;

    	for(L2PcInstance pc : _RegistedPlayers)
    	{
        	if(pc.getInventory().getInventoryItemCount(_ScrollId, -1) < 1)
        	{
    			SystemMessage sm = new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
    			pc.sendPacket(sm);
    			pc.sendMessage("𖞂ĂȂ߁Aꂪۂ܂B");
    			isReadyToInvade = false;
    		}
    	}

    	if(!isReadyToInvade)
    	{
        	for(L2PcInstance pc : _RegistedPlayers)
        	{
    			pc.sendMessage("𖞂ĂȂvC[邽߁Aꂪۂ܂B");
        	}

    		return;
    	}

    	for(L2PcInstance pc : _RegistedPlayers)
    	{
    		pc.destroyItemByItemId("Quest", _ScrollId, 1, _Commander, true);
    	}

    	_PlayersInLair.clear();

    	for(L2PcInstance pc : _RegistedPlayers)
    	{
    		if(locId >= 5) locId = 0;

   			pc.teleToLocation(_InvadeLoc[locId][0] + Rnd.get(50), _InvadeLoc[locId][1] + Rnd.get(50), _InvadeLoc[locId][2]);
   			_PlayersInLair.add(pc);

    		locId++;
    	}
    }

    // Is the door of room1 in confirmation to open.
    public void onKillHallAlarmDevice()
    {
    	int killCnt = 0;

    	for(L2NpcInstance HallAlarmDevice : _HallAlarmDevices)
    	{
    		if(HallAlarmDevice.isDead()) killCnt++;
    	}

    	switch(killCnt)
    	{
    	case 1:
    		if(Rnd.get(100) < 10)
    		{
    			openRoom1Doors();
    			openRoom2OutsideDoors();
    			spawnRoom2InsideMob();
    		}
    		else
    		{
    			if(_Room1SpawnTask != null)
    				_Room1SpawnTask.cancel(true);

    			_Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs2nd(),3000);
    		}
    		break;
    	case 2:
    		if(Rnd.get(100) < 20)
    		{
    			openRoom1Doors();
    			openRoom2OutsideDoors();
    			spawnRoom2InsideMob();
    		}
    		else
    		{
    			if(_Room1SpawnTask != null)
    				_Room1SpawnTask.cancel(true);

    			_Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs3rd(),3000);
    		}
    		break;
    	case 3:
    		if(Rnd.get(100) < 30)
    		{
    			openRoom1Doors();
    			openRoom2OutsideDoors();
    			spawnRoom2InsideMob();
    		}
    		else
    		{
    			if(_Room1SpawnTask != null)
    				_Room1SpawnTask.cancel(true);

    			_Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs4th(),3000);
    		}
    		break;
    	case 4:
			openRoom1Doors();
			openRoom2OutsideDoors();
			spawnRoom2InsideMob();
		}
    }

    // Is the door of inside of room2 in confirmation to open.
    public void onKillDarkChoirPlayer()
    {
    	int killCnt = 0;

    	for(L2NpcInstance DarkChoirPlayer : _Room2InsideMonsters)
    	{
    		if(DarkChoirPlayer.isDead()) killCnt++;
    	}

    	if(_Room2InsideMonsters.size() <= killCnt)
    	{
    		if(_Room2InsideDoorOpenTask != null) _Room2InsideDoorOpenTask.cancel(true);
    		if(_Room2OutsideSpawnTask != null) _Room2OutsideSpawnTask.cancel(true);

    		_Room2InsideDoorOpenTask =
    			ThreadPoolManager.getInstance().scheduleGeneral(new OpenRoom2InsideDoors(),3000);
    		_Room2OutsideSpawnTask =
    			ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom2OutsideMobs(),4000);
    	}
    }

    // Is the door of outside of room2 in confirmation to open.
    public void onKillDarkChoirCaptain()
    {
    	int killCnt = 0;

    	for(L2NpcInstance DarkChoirCaptain : _DarkChoirCaptains)
    	{
    		if(DarkChoirCaptain.isDead()) killCnt++;
    	}

    	if(_DarkChoirCaptains.size() <= killCnt)
    	{
    		openRoom2OutsideDoors();

    		for(L2NpcInstance mob : _Room2OutsideMonsters)
    		{
    			mob.deleteMe();
    			mob.getSpawn().stopRespawn();
    		}

        	for(L2NpcInstance DarkChoirCaptain : _DarkChoirCaptains)
        	{
        		DarkChoirCaptain.deleteMe();
        		DarkChoirCaptain.getSpawn().stopRespawn();
        	}
    	}
    }

    private void openRoom1Doors()
    {
    	for(L2NpcInstance npc : _HallAlarmDevices)
    	{
    		npc.deleteMe();
    		npc.getSpawn().stopRespawn();
    	}

    	for(L2NpcInstance npc : _Room1Monsters)
    	{
    		npc.deleteMe();
    		npc.getSpawn().stopRespawn();
    	}

    	for(L2DoorInstance door : _Room1Doors)
    	{
    		door.openMe();
    	}
    }

    protected void openRoom2InsideDoors()
    {
    	for(L2DoorInstance door : _Room2InsideDoors)
    	{
    		door.openMe();
    	}
    }

    protected void openRoom2OutsideDoors()
    {
    	for(L2DoorInstance door : _Room2OutsideDoors)
    	{
    		door.openMe();
    	}
    	_Room3Door.openMe();
    }

    protected void closeRoom2OutsideDoors()
    {
    	for(L2DoorInstance door : _Room2OutsideDoors)
    	{
    		door.closeMe();
    	}
    	_Room3Door.closeMe();
    }

    private void spawnRoom2InsideMob()
    {
		L2NpcInstance mob;
		for(L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom2InsideSpawnList())
		{
			mob = spawn.doSpawn();
			mob.getSpawn().stopRespawn();
			_Room2InsideMonsters.add(mob);
		}
    }

    public void setReachToHall()
    {
    	_IsReachToHall = true;
    }

    protected void doCheckTimeUp(int remaining)
    {
    	if(_IsReachToHall)
    	{
    		FrintezzaManager.getInstance().setScarletSpawnTask();
    		return;
    	}

    	CreatureSay cs = null;
		int timeLeft;
		int interval;

		if(remaining > 300000)
		{
			timeLeft = remaining / 60000;
			interval = 300000;
			cs = new CreatureSay(0,9,"m点","c" + timeLeft + "łB");
			//cs = new CreatureSay(0,9,"notice","It is " + timeLeft + " minutes of remaining time.");
			remaining = remaining - 300000;
		}
		else if (remaining > 60000)
		{
			timeLeft = remaining / 60000;
			interval = 60000;
			cs = new CreatureSay(0,9,"m点","c" + timeLeft + "łB");
			//cs = new CreatureSay(0,9,"notice","It is " + timeLeft + " minutes of remaining time.");
			remaining = remaining - 60000;
		}
		else if (remaining > 30000)
		{
			timeLeft = remaining / 1000;
			interval = 30000;
			cs = new CreatureSay(0,9,"m点","c" + timeLeft + "błB");
			//cs = new CreatureSay(0,9,"notice","It is " + timeLeft + " seconds of remaining time.");
			remaining = remaining - 30000;
		}
		else
		{
			timeLeft = remaining / 1000;
			interval = 10000;
			cs = new CreatureSay(0,9,"m点","c" + timeLeft + "błB");
			//cs = new CreatureSay(0,9,"notice","It is " + timeLeft + " seconds of remaining time.");
			remaining = remaining - 10000;
		}

		for(L2PcInstance pc : getPlayersInLair())
		{
			pc.sendPacket(cs);
		}

		if(_CheckTimeUpTask != null)
			_CheckTimeUpTask.cancel(true);
   		if(remaining >= 10000)
   			_CheckTimeUpTask =
   				ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(remaining),interval);
   		else
   			_CheckTimeUpTask =
   				ThreadPoolManager.getInstance().scheduleGeneral(new TimeUp(),interval);
    }

    protected void cleanUpTomb()
    {
    	if(_IsReachToHall) FrintezzaManager.getInstance().setUnspawn();
    	initDoors();
    	cleanUpMobs();
    	banishesPlayers();
    	cleanUpRegister();
    	_IsInvaded = false;
    	_IsReachToHall = false;

    	if(_InvadeTask != null) _InvadeTask.cancel(true);
    	if(_RegistrationTimeInfoTask != null) _RegistrationTimeInfoTask.cancel(true);
    	if(_Room1SpawnTask != null) _Room1SpawnTask.cancel(true);
    	if(_Room2InsideDoorOpenTask != null) _Room2InsideDoorOpenTask.cancel(true);
    	if(_Room2OutsideSpawnTask != null) _Room2OutsideSpawnTask.cancel(true);
    	if(_CheckTimeUpTask != null) _CheckTimeUpTask.cancel(true);
    	if(_OnPlayersAnnihilatedTask != null) _OnPlayersAnnihilatedTask.cancel(true);

    	_InvadeTask = null;
    	_RegistrationTimeInfoTask = null;
    	_Room1SpawnTask = null;
    	_Room2InsideDoorOpenTask = null;
    	_Room2OutsideSpawnTask = null;
    	_CheckTimeUpTask = null;
    	_OnPlayersAnnihilatedTask = null;

    }

    // delete all mobs from tomb.
    private void cleanUpMobs()
    {
    	for(L2NpcInstance mob : _HallAlarmDevices)
    	{
    		mob.getSpawn().stopRespawn();
    		mob.deleteMe();
    	}
    	_HallAlarmDevices.clear();

    	for(L2NpcInstance mob : _DarkChoirPlayers)
    	{
    		mob.getSpawn().stopRespawn();
    		mob.deleteMe();
    	}
    	_DarkChoirPlayers.clear();

    	for(L2NpcInstance mob : _DarkChoirCaptains)
    	{
    		mob.getSpawn().stopRespawn();
    		mob.deleteMe();
    	}
    	_DarkChoirCaptains.clear();

    	for(L2NpcInstance mob : _Room1Monsters)
    	{
    		mob.getSpawn().stopRespawn();
    		mob.deleteMe();
    	}
    	_Room1Monsters.clear();

    	for(L2NpcInstance mob : _Room2InsideMonsters)
    	{
    		mob.getSpawn().stopRespawn();
    		mob.deleteMe();
    	}
    	_Room2InsideMonsters.clear();

    	for(L2NpcInstance mob : _Room2OutsideMonsters)
    	{
    		mob.getSpawn().stopRespawn();
    		mob.deleteMe();
    	}
    	_Room2OutsideMonsters.clear();
    }

    private void cleanUpRegister()
    {
    	_Commander = null;
    	_PartyLeaders.clear();
    	_RegistedPlayers.clear();
    }

    private void banishesPlayers()
    {
    	if(_PlayersInLair == null || _PlayersInLair.isEmpty()) return;

    	for(L2PcInstance pc : getPlayersInLair())
    	{
    		int locId = Rnd.get(4);
    		int rndX = Rnd.get(100);
    		int rndY = Rnd.get(100);

			pc.teleToLocation(
					_BanishmentLocation[locId][0] + rndX,
					_BanishmentLocation[locId][1] + rndY,
					_BanishmentLocation[locId][2]);
    	}

    	_PlayersInLair.clear();
    }

    private class SpawnRoom1Mobs1st implements Runnable
    {
    	public SpawnRoom1Mobs1st()
    	{

    	}

    	public void run()
    	{
    		L2NpcInstance mob;
    		for(L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList1st())
    		{
    			if(spawn.getNpcid() == 18328)
    			{
    				mob = spawn.doSpawn();
    				mob.getSpawn().stopRespawn();
    				_HallAlarmDevices.add(mob);
    			}
    			else
    			{
    				mob = spawn.doSpawn();
    				mob.getSpawn().stopRespawn();
    				_Room1Monsters.add(mob);
    			}
    		}
    	}
    }

    private class SpawnRoom1Mobs2nd implements Runnable
    {
    	public SpawnRoom1Mobs2nd()
    	{

    	}

    	public void run()
    	{
    		L2NpcInstance mob;
    		for(L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList2nd())
    		{
				mob = spawn.doSpawn();
				mob.getSpawn().stopRespawn();
   				_Room1Monsters.add(mob);
    		}
    	}
    }

    private class SpawnRoom1Mobs3rd implements Runnable
    {
    	public SpawnRoom1Mobs3rd()
    	{

    	}

    	public void run()
    	{
    		L2NpcInstance mob;
    		for(L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList3rd())
    		{
				mob = spawn.doSpawn();
				mob.getSpawn().stopRespawn();
   				_Room1Monsters.add(mob);
    		}
    	}
    }

    private class SpawnRoom1Mobs4th implements Runnable
    {
    	public SpawnRoom1Mobs4th()
    	{

    	}

    	public void run()
    	{
    		L2NpcInstance mob;
    		for(L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList4th())
    		{
				mob = spawn.doSpawn();
				mob.getSpawn().stopRespawn();
   				_Room1Monsters.add(mob);
    		}
    	}
    }

    private class OpenRoom2InsideDoors implements Runnable
    {
    	public OpenRoom2InsideDoors()
    	{

    	}

    	public void run()
    	{
    		closeRoom2OutsideDoors();
    		openRoom2InsideDoors();
    	}
    }

    private class SpawnRoom2OutsideMobs implements Runnable
    {
    	public SpawnRoom2OutsideMobs()
    	{

    	}

    	public void run()
    	{
    		for(L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom2OutsideSpawnList())
    		{
    			if(spawn.getNpcid() == 18334)
    			{
    				L2NpcInstance mob = spawn.doSpawn();
    				mob.getSpawn().stopRespawn();
        			_DarkChoirCaptains.add(mob);
    			}
    			else
    			{
    				L2NpcInstance mob = spawn.doSpawn();
    				mob.getSpawn().startRespawn();
    				_Room2OutsideMonsters.add(mob);
    			}
    		}
   		}
    }

    private class AnnouncementRegstrationInfo implements Runnable
    {
    	private L2NpcInstance _npc = null;
    	private int _remaining;
    	public AnnouncementRegstrationInfo(L2NpcInstance npc,int remaining)
    	{
    		_npc = npc;
    		_remaining = remaining;
    	}

    	public void run()
    	{
    		doAnnouncementRegstrationInfo(_npc,_remaining);
    	}
    }

    private class Invade implements Runnable
    {
    	public Invade()
    	{

    	}

    	public void run()
    	{
    		doInvade();
    	}
    }

    private class CheckTimeUp implements Runnable
    {
    	private int _remaining;
    	public CheckTimeUp(int remaining)
    	{
    		_remaining = remaining;
    	}

    	public void run()
    	{
    		doCheckTimeUp(_remaining);
    	}
    }

    private class TimeUp implements Runnable
    {
    	public TimeUp()
    	{

    	}

    	public void run()
    	{
    		cleanUpTomb();
    	}
    }

    // Whether the players was annihilated is confirmed.
    public synchronized boolean isPlayersAnnihilated()
    {
    	for (L2PcInstance pc : getPlayersInLair())
		{
			// player is must be alive and stay inside of lair.
			if (!pc.isDead())
			{
				return false;
			}
		}
		return true;
    }

	// When the party is annihilated, they are banished.
    public void checkAnnihilated()
    {
    	if(isPlayersAnnihilated())
    	{
    		_OnPlayersAnnihilatedTask =
				ThreadPoolManager.getInstance().scheduleGeneral(new OnPlayersAnnihilatedTask(),5000);
    	}
    }

    // When the party is annihilated, they are banished.
	private class OnPlayersAnnihilatedTask implements Runnable
	{
		public OnPlayersAnnihilatedTask()
		{
		}

		public void run()
		{
		    // banishes players from lair.
			cleanUpTomb();
		}
	}

}
