/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.List;

public class ShowBoard extends L2GameServerPacket
{
	private static final String _S__6E_SHOWBOARD = "[S] 7b ShowBoard";

	private String _htmlCode;
	private String _id;
	private List<String> _arg;

	public ShowBoard(String htmlCode, String id)
	{
		_id = id;
		_htmlCode = htmlCode; // html code must not exceed 8192 bytes
	}

	public ShowBoard(List<String> arg)
	{
		_id = "1002";
		_htmlCode = null;
		_arg = arg;

	}

	private byte[] get1002()		//XXX:[JOJO] for UNICOE
	{
		int len = _id.length() * 2 + 2;
		for (String arg : _arg)
		{
			len += arg.length() * 2 + 4;
		}
		byte data[] = new byte[len];
		int i = 0;
		for (int j = 0; j < _id.length(); j++)
		{
			char u = _id.charAt(j);
			data[i++] = (byte)(u     );
			data[i++] = (byte)(u >> 8);
		}
		data[i++] = 0x08;
		data[i++] = 0x00;
		for (String arg : _arg)
		{
			for (int j = 0; j < arg.length(); j++)
			{
				char u = arg.charAt(j);
				data[i++] = (byte)(u     );
				data[i++] = (byte)(u >> 8);
			}
			data[i++] = 0x20;
			data[i++] = 0x00;
			data[i++] = 0x08;
			data[i++] = 0x00;
		}
//		System.out.println("__BASENAME__:__LINE__:"); DUMP(data);
		return data;
	}

	@Override
	protected final void writeImpl()
	{
		writeC(0x7b);
		writeC(0x01); //c4 1 to show community 00 to hide
		writeS("bypass _bbshome"); // top
		writeS("bypass _bbsgetfav"); // favorite
		writeS("bypass _bbsloc"); // region
		writeS("bypass _bbsclan"); // clan
		writeS("bypass _bbsmemo"); // memo
		writeS("bypass _bbsmail"); // mail
		writeS("bypass _bbsfriends"); // friends
		writeS("bypass bbs_add_fav"); // add fav.
		// [L2J_JP EDIT - TSL][JOJO]
		if (_id.equals("1002"))
		{
			writeB(get1002());
		}
		else
		{
			byte data[] = new byte[_id.length() * 2 + 2];
			int i = 0;
			for (int j = 0; j < _id.length(); j++)
			{
				char u = _id.charAt(j);
				data[i++] = (byte)(u     );
				data[i++] = (byte)(u >> 8);
			}
			data[i++] = 0x08;
			data[i++] = 0x00;
			writeB(data);
			writeS(_htmlCode); // current page
//			System.out.println("__BASENAME__:__LINE__:"); DUMP(data);
		}
	}

	/* (non-Javadoc)
	 * @see net.sf.l2j.gameserver.serverpackets.ServerBasePacket#getType()
	 */
	@Override
	public String getType()
	{
		return _S__6E_SHOWBOARD;
	}

//	private void DUMP(byte[] data)
//	{
//		char[] dummy = new char[8];
//		for (int dx=0; dx < data.length; dx += 16) {
//			System.out.print("\t");
//			for (int cx=0; cx < 16; cx += 2) {
//				if (dx+cx < data.length) {
//					int ax = (data[dx+cx+0] & 0xFF) + (data[dx+cx+1] & 0xFF) * 256;
//					System.out.printf("%04X ", ax);
//				} else {
//					System.out.print("     ");
//				}
//			}
//			System.out.print(": ");
//			int n = 0;
//			for (int cx=0; cx < 16; cx += 2) {
//				if (dx+cx < data.length) {
//					int ax = (data[dx+cx+0] & 0xFF) + (data[dx+cx+1] & 0xFF) * 256;
//					if (ax < 0x20 || ax >= 0x7F && ax <= 0xA0) ax = '.';
//					dummy[n++] = (char)ax;
//				}
//			}
//			System.out.println(new String(dummy, 0, n));
//		}
//	}
}
