/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.instancemanager.grandbosses;
/*package com.l2jfree.gameserver.instancemanager.grandbosses;*/

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

import javolution.util.FastList;
import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.GrandBossState;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;

/**
 * 
 * This class ...
 * Management for fight with sailren.
 * @version $Revision: $ $Date: $
 * @author  L2J_JP SANDMAN
 
 * @author JOJO Sync: l2jfree-core rev6689, timestamp 2009/07/22 23:45
 * @author JOJO Sync: l2jfree-core rev7164, timestamp 2009/09/20 04:37
 */
public class SailrenManager extends BossLair
{
	@SuppressWarnings("synthetic-access")
	private static final class SingletonHolder
	{
		protected static final SailrenManager INSTANCE = new SailrenManager();
	}
	
	public static SailrenManager getInstance()
	{
		return SingletonHolder.INSTANCE;
	}

	// NPC
	private static final int VELOCIRAPTOR = 22218;	//FLvg
	private static final int PTEROSAUR = 22199;		//tHNX
	private static final int TYRANNOSAURUS = 22217;	//eBmUEX
	private static final int SAILREN = 29065;		//TC
	private static final int _bossId = 29065;

	// Teleport cube location.
	private final int				_sailrenCubeLocation[][]	=
																{
																{ 27734, -6838, -1982, 0 } };
	protected List<L2Spawn>			_sailrenCubeSpawn			= new FastList<L2Spawn>();
	protected List<L2Npc>	_sailrenCube				= new FastList<L2Npc>();

	// Spawn data of monsters
	protected L2Spawn				_velociraptorSpawn;		// @Lvg
	protected L2Spawn				_pterosaurSpawn;		// tHNX
	protected L2Spawn				_tyrannoSpawn;			// eBmUEX
	protected L2Spawn				_sailrenSapwn;			// TC

	// Instance of monsters
	protected L2Npc			_velociraptor;		// @Lvg
	protected L2Npc			_pterosaur;			// tHNX
	protected L2Npc			_tyranno;			// eBmUEX
	protected L2Npc			_sailren;			// TC

	// Tasks
	protected ScheduledFuture<?>	_cubeSpawnTask				= null;
	protected ScheduledFuture<?>	_sailrenSpawnTask			= null;
	protected ScheduledFuture<?>	_intervalEndTask			= null;
	protected ScheduledFuture<?>	_activityTimeEndTask		= null;
	protected ScheduledFuture<?>	_onPartyAnnihilatedTask		= null;
	protected ScheduledFuture<?>	_socialTask					= null;

	// State of Sailren's lair.
	protected boolean				_isAlreadyEnteredOtherParty	= false;

	private SailrenManager()
	{
	//	_questName = "sailren";
		_state = new GrandBossState(_bossId);

		if (registerZone(27734, -6938, -1982) == null)		//[JOJO]
			_log.warning("SailrenManager : Failed to load zone 'Lair of Sailren'");
	}

	// Init.
	@Override
	public void init()
	{
		// Init state.
		_isAlreadyEnteredOtherParty = false;

		// Setting spawn data of monsters.
		try
		{
			L2NpcTemplate template1;

			// @Lvg
			template1 = NpcTable.getInstance().getTemplate(VELOCIRAPTOR); //Velociraptor
			_velociraptorSpawn = new L2Spawn(template1);
			_velociraptorSpawn.setLocx(27852);
			_velociraptorSpawn.setLocy(-5536);
			_velociraptorSpawn.setLocz(-1983);
			_velociraptorSpawn.setHeading(44732);
			_velociraptorSpawn.setAmount(1);
			_velociraptorSpawn.stopRespawn(); /*_velociraptorSpawn.setRespawnDelay(Config.FWS_ACTIVITYTIMEOFMOBS * 2);*/
		//	SpawnTable.getInstance().addNewSpawn(_velociraptorSpawn, false);

			// tHNX
			template1 = NpcTable.getInstance().getTemplate(PTEROSAUR); //Pterosaur
			_pterosaurSpawn = new L2Spawn(template1);
			_pterosaurSpawn.setLocx(27852);
			_pterosaurSpawn.setLocy(-5536);
			_pterosaurSpawn.setLocz(-1983);
			_pterosaurSpawn.setHeading(44732);
			_pterosaurSpawn.setAmount(1);
			_pterosaurSpawn.stopRespawn(); /*_pterosaurSpawn.setRespawnDelay(Config.FWS_ACTIVITYTIMEOFMOBS * 2);*/
		//	SpawnTable.getInstance().addNewSpawn(_pterosaurSpawn, false);

			// eBmUEX
			template1 = NpcTable.getInstance().getTemplate(TYRANNOSAURUS); //Tyrannosaurus
			_tyrannoSpawn = new L2Spawn(template1);
			_tyrannoSpawn.setLocx(27852);
			_tyrannoSpawn.setLocy(-5536);
			_tyrannoSpawn.setLocz(-1983);
			_tyrannoSpawn.setHeading(44732);
			_tyrannoSpawn.setAmount(1);
			_tyrannoSpawn.stopRespawn(); /*_tyrannoSpawn.setRespawnDelay(Config.FWS_ACTIVITYTIMEOFMOBS * 2);*/
		//	SpawnTable.getInstance().addNewSpawn(_tyrannoSpawn, false);

			// TC
			template1 = NpcTable.getInstance().getTemplate(SAILREN); //Sailren
			_sailrenSapwn = new L2Spawn(template1);
			_sailrenSapwn.setLocx(27810);
			_sailrenSapwn.setLocy(-5655);
			_sailrenSapwn.setLocz(-1983);
			_sailrenSapwn.setHeading(44732);
			_sailrenSapwn.setAmount(1);
			_sailrenSapwn.stopRespawn(); /*_sailrenSapwn.setRespawnDelay(Config.FWS_ACTIVITYTIMEOFMOBS * 2);*/
		//	SpawnTable.getInstance().addNewSpawn(_sailrenSapwn, false);

		}
		catch (Exception e)
		{
			_log.warning(e.getMessage());
		}

		// Setting spawn data of teleporte cube.
		try
		{
			L2NpcTemplate cube = NpcTable.getInstance().getTemplate(32107);
			L2Spawn spawnDat;

			for (int[] element : _sailrenCubeLocation)
			{
				spawnDat = new L2Spawn(cube);
				spawnDat.setAmount(1);
				spawnDat.setLocx(element[0]);
				spawnDat.setLocy(element[1]);
				spawnDat.setLocz(element[2]);
				spawnDat.setHeading(element[3]);
				spawnDat.stopRespawn(); /*spawnDat.setRespawnDelay(60);*/
				spawnDat.setLocation(0);
			//	SpawnTable.getInstance().addNewSpawn(spawnDat, false);
				_sailrenCubeSpawn.add(spawnDat);
			}
		}
		catch (Exception e)
		{
			_log.warning(e.getMessage());
		}

		_log.info("SailrenManager : State of Sailren is " + _state.getStateName() + ".");
		if (_state.getState() != GrandBossState.StateEnum.NOTSPAWN)
			setIntervalEndTask();

		_log.info("SailrenManager : Next spawn date of Sailren is " + _state.respawnTimeFormat() + ".");
		_log.info("SailrenManager : Init SailrenManager.");
	}

	// Whether it is permitted to enter the sailren's lair is confirmed.
	public int canIntoSailrenLair(L2PcInstance pc)		//<<== sailren.py:onTalk()
	{
		if (!Config.FWS_ENABLESINGLEPLAYER && pc.getParty() == null)
			return -4;
		final int alive = _state.getState();
		if (alive == GrandBossState.StateEnum.ALIVE || alive == GrandBossState.StateEnum.DEAD || alive == GrandBossState.StateEnum.INTERVAL)
			return alive;
		else if (_isAlreadyEnteredOtherParty)
			return GrandBossState.StateEnum.ALIVE;
		else
			return alive;

	}

	// Set Sailren spawn task.
	public void setSailrenSpawnTask(int npcId)		//<<== sailren.py:onKill()
	{
		if (npcId == VELOCIRAPTOR && getPlayersInside().size() != 0)
			return;

		if (_sailrenSpawnTask == null)
		{
			_sailrenSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SailrenSpawn(npcId), Config.FWS_INTERVALOFNEXTMONSTER);
		}
	}

	// Teleporting player to sailren's lair.
	public void entryToSailrenLair(L2PcInstance pc)		//<<== sailren.py:onTalk()
	{
		int driftx;
		int drifty;

		if (canIntoSailrenLair(pc) != 0)
		{
			pc.sendMessage("𖞂ĂȂ߁Aꂪۂ܂B");
		//	pc.sendMessage("Entrance was refused because it did not satisfy it.");
			_isAlreadyEnteredOtherParty = false;
			return;
		}

		if (true)
		{
			for (L2PcInstance mem : this.getPartyMembers(pc))
			{
				// teleporting it within alive and the range of recognition of the leader of the party.
				if (!mem.isDead() && Util.checkIfInRange(700, pc, mem, true))
				{
					driftx = Rnd.get(-80, 80);
					drifty = Rnd.get(-80, 80);
					getZone().allowPlayerEntry(mem, 30); //+[JOJO]
					mem.teleToLocation(27734 + driftx, -6938 + drifty, -1982);
				}
			}
		}
		_isAlreadyEnteredOtherParty = true;
	}

	// When annihilating or limit of time coming, the compulsion movement players from the sailren's lair.
	@Override
	public void banishForeigners()
	{
		super.banishForeigners();
		_isAlreadyEnteredOtherParty = false;
	}

	// Clean up Sailren's lair.
	@Override
	public void setUnspawn()
	{
		// Eliminate players.
		banishForeigners();

		// Delete teleport cube.
		for (L2Npc cube : _sailrenCube)
		{
		//	cube.getSpawn().stopRespawn();
			cube.deleteMe();
		}
		_sailrenCube.clear();

		// Not executed tasks is canceled.
		if (_cubeSpawnTask != null)
		{
			_cubeSpawnTask.cancel(true);
			_cubeSpawnTask = null;
		}
		if (_sailrenSpawnTask != null)
		{
			_sailrenSpawnTask.cancel(true);
			_sailrenSpawnTask = null;
		}
		if (_intervalEndTask != null)
		{
			_intervalEndTask.cancel(true);
			_intervalEndTask = null;
		}
		if (_activityTimeEndTask != null)
		{
			_activityTimeEndTask.cancel(true);
			_activityTimeEndTask = null;
		}

		// Init state of sailren's lair.
		if (_velociraptor != null) { _velociraptor.deleteMe(); _velociraptor = null; }	// @Lvg
		if (_pterosaur != null) { _pterosaur.deleteMe(); _pterosaur = null; }			// tHNX
		if (_tyranno != null) { _tyranno.deleteMe(); _tyranno = null; }					// eBmUEX
		if (_sailren != null) { _sailren.deleteMe(); _sailren = null; }					// TC

		// Interval begin.
		setIntervalEndTask();
	}

	// Spawn teleport cube.
	public void spawnCube()
	{
		for (L2Spawn spawnDat : _sailrenCubeSpawn)
		{
			_sailrenCube.add(spawnDat.doSpawn());
		}
	}

	// Task of teleport cube spawn.
	public void setCubeSpawn()		//<<== sailren.py:onKill()
	{
		_state.setState(GrandBossState.StateEnum.DEAD);
		_state.update();

		_cubeSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new CubeSpawn(), 10000);

		//[JOJO]
		if (_activityTimeEndTask != null)
			_activityTimeEndTask.cancel(false);
		_activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(_sailren), 900000);
	}

	// Task of interval of sailren spawn.
	public void setIntervalEndTask()
	{
		if (_state.getState() != GrandBossState.StateEnum.INTERVAL)
		{
			_state
					.setRespawnDate(Config.FWS_FIXINTERVALOFSAILRENSPAWN
							+ Rnd.get(Config.FWS_RANDOMINTERVALOFSAILRENSPAWN));
			_state.setState(GrandBossState.StateEnum.INTERVAL);
			_state.update();
		}

		_intervalEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new IntervalEnd(), _state.getInterval());
		_log.info("SailrenManager : Interval START.");
		_log.info("SailrenManager : Next spawn date of Sailren is " + _state.respawnTimeFormat() + ".");	//[JOJO]
	}

	// Spawn monster.
	private class SailrenSpawn implements Runnable
	{
		private final int				_npcId;
		private final L2CharPosition	_pos	= new L2CharPosition(27628, -6109, -1982, 44732);

		public SailrenSpawn(int npcId)
		{
			_npcId = npcId;
		}

		public void run()
		{
			switch (_npcId)
			{
			case VELOCIRAPTOR: // FLvg
				_velociraptor = _velociraptorSpawn.doSpawn();
				_velociraptor.setIsRaid(true);	//[JOJO] v:qQC
				_velociraptor.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, _pos);
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new Social(_velociraptor, 2), 6000);
				if (_activityTimeEndTask != null)
				{
					_activityTimeEndTask.cancel(true);
					_activityTimeEndTask = null;
				}
				_activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(_velociraptor), Config.FWS_ACTIVITYTIMEOFMOBS);
				break;
			case PTEROSAUR: // tHNX
			//	_velociraptorSpawn.stopRespawn();
				_pterosaur = _pterosaurSpawn.doSpawn();
				_pterosaur.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, _pos);
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new Social(_pterosaur, 2), 6000);
				if (_activityTimeEndTask != null)
				{
					_activityTimeEndTask.cancel(true);
					_activityTimeEndTask = null;
				}
				_activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(_pterosaur), Config.FWS_ACTIVITYTIMEOFMOBS);
				break;
			case TYRANNOSAURUS: // eBmUEX
			//	_pterosaurSpawn.stopRespawn();
				_tyranno = _tyrannoSpawn.doSpawn();
				_tyranno.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, _pos);
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new Social(_tyranno, 2), 6000);
				if (_activityTimeEndTask != null)
				{
					_activityTimeEndTask.cancel(true);
					_activityTimeEndTask = null;
				}
				_activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(_tyranno), Config.FWS_ACTIVITYTIMEOFMOBS);
				break;
			case SAILREN: // TC
			//	_tyrannoSpawn.stopRespawn();
				_sailren = _sailrenSapwn.doSpawn();

				_state.setRespawnDate(Config.FWS_FIXINTERVALOFSAILRENSPAWN
						+ Rnd.get(Config.FWS_RANDOMINTERVALOFSAILRENSPAWN)
						+ Config.FWS_ACTIVITYTIMEOFMOBS);
				_state.setState(GrandBossState.StateEnum.ALIVE);
				_state.update();

				_sailren.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, _pos);
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new Social(_sailren, 2), 6000);
				if (_activityTimeEndTask != null)
				{
					_activityTimeEndTask.cancel(true);
					_activityTimeEndTask = null;
				}
				_activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(_sailren), Config.FWS_ACTIVITYTIMEOFMOBS);
				break;
			}

			if (_sailrenSpawnTask != null)
			{
				_sailrenSpawnTask.cancel(true);
				_sailrenSpawnTask = null;
			}
		}
	}

	// Spawn teleport cube.
	/*private*/ class CubeSpawn implements Runnable
	{
		public void run()
		{
			spawnCube();
		}
	}

	// Limit of time coming.
	private class ActivityTimeEnd implements Runnable
	{
	//	private L2Npc	_mob;
	//	
		public ActivityTimeEnd(L2Npc npc)
		{
	//		_mob = npc;
		}
		
		public void run()
		{
	//		if (!_mob.isDead())
	//		{
	//			_mob.deleteMe();
	//			_mob.getSpawn().stopRespawn();
	//			_mob = null;
	//		}
			// clean up sailren's lair.
			setUnspawn();
		}
	}

	// Interval end.
	/*private*/ class IntervalEnd implements Runnable
	{
		public void run()
		{
			_state.setState(GrandBossState.StateEnum.NOTSPAWN);
			_state.update();
			_log.info("SailrenManager : Interval END.");
		}
	}

	// Social.
	private class Social implements Runnable
	{
		private final int				_action;
		private final L2Npc	_npc;

		public Social(L2Npc npc, int actionId)
		{
			_npc = npc;
			_action = actionId;
		}

		public void run()
		{
			getZone().updateKnownList(_npc);	//[JOJO]
			SocialAction sa = new SocialAction(_npc.getObjectId(), _action);
			_npc.broadcastPacket(sa);
		}
	}

	//[JOJO]-------------------------------------------------
	List<L2PcInstance> getPartyMembers(L2PcInstance player)
	{
		L2Party party;
		if ((party = player.getParty()) != null)
			return party.getPartyMembers();
		else
		{
			List<L2PcInstance> m = new ArrayList<L2PcInstance>(1);
			m.add(player);
			return m;
		}
	}
	//-------------------------------------------------------
}
