/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.less.than.more;

import java.util.logging.Level;
import java.util.logging.Logger;
import jp.que.ti.yhj.less.than.more.ByteReader;

public abstract class ByteReaderBase
implements ByteReader {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private byte[] _byteTemp4viewToCrLf = new byte[1024];

    protected byte[] readToCrLf(long position) {
        this.setPosition(position);
        int dataIdx = 0;
        int lastCRLFPos = -1;
        boolean notEnd = true;
        while (notEnd) {
            byte tempByte;
            int tmp = 0;
            tmp = this.read();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(Integer.toHexString(tmp & 0xFF) + "<--" + this.log.getName());
                this.log.finest(new String(new byte[]{(byte)tmp}));
            }
            if (tmp < 0) {
                notEnd = false;
                continue;
            }
            this._byteTemp4viewToCrLf = this.extendBytesIfTooSmall(this._byteTemp4viewToCrLf, dataIdx);
            this._byteTemp4viewToCrLf[dataIdx] = tempByte = (byte)tmp;
            if (this.isForward()) {
                if (tempByte == 10) {
                    lastCRLFPos = dataIdx;
                } else if (dataIdx - 1 >= 0 && this._byteTemp4viewToCrLf[dataIdx - 1] == 13) {
                    lastCRLFPos = dataIdx - 1;
                }
            } else if (tempByte == 13) {
                lastCRLFPos = dataIdx;
            } else if (dataIdx - 1 >= 0 && this._byteTemp4viewToCrLf[dataIdx - 1] == 10) {
                lastCRLFPos = dataIdx - 1;
            }
            if (lastCRLFPos >= 0) {
                notEnd = false;
            }
            ++dataIdx;
        }
        int copyLength = 0;
        copyLength = lastCRLFPos >= 0 ? lastCRLFPos + 1 : dataIdx;
        byte[] tmpBytes = new byte[copyLength];
        System.arraycopy(this._byteTemp4viewToCrLf, 0, tmpBytes, 0, copyLength);
        return tmpBytes;
    }

    private byte[] extendBytesIfTooSmall(byte[] bytes, int newLength) {
        byte[] newTemp = null;
        if (bytes.length > newLength) {
            return bytes;
        }
        newTemp = new byte[newLength * 2];
        System.arraycopy(bytes, 0, newTemp, 0, bytes.length);
        return newTemp;
    }
}

