/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import jp.que.ti.yhj.less.than.more.CannotContinueException;
import jp.que.ti.yhj.less.than.more.LessThanMoreController;
import jp.que.ti.yhj.less.than.more.command.IllegalPositionException;
import jp.que.ti.yhj.less.than.more.command.SearchBackwardCMD;
import jp.que.ti.yhj.less.than.more.command.SearchBaseCMD;
import jp.que.ti.yhj.less.than.more.command.SearchForwardCMD;
import jp.que.ti.yhj.utils.ConsoleUtils;
import jp.que.ti.yhj.utils.StringUtils;
import jp.que.ti.yhj.utils.log.LogUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class LessThanMoreCUIController
extends LessThanMoreController {
    static final Options LINE_OPTIONS;
    static final Options VIEW_LOOP_HELP_COMMAND;
    private String nowSearchingKey = "";

    public static void main(String[] args) {
        LogUtils.initLoggerConfig();
        LessThanMoreCUIController controller = new LessThanMoreCUIController();
        try {
            controller.lineParser(args);
        }
        catch (CannotContinueException e) {
            System.exit(0);
        }
        controller.getViewCommand().execute();
        System.out.println(controller.getViewer().getLastViewCache());
        boolean notEnd = true;
        while (notEnd) {
            try {
                System.out.println("   *** now position=" + controller.getViewer().getPosition() + "input command! input \"h\" then displaying a help ***");
                String command = ConsoleUtils.in("\u30b3\u30de\u30f3\u30c9");
                controller.viewLoop(command.trim());
            }
            catch (IllegalPositionException e) {
                System.out.println(controller.getViewer().getLastViewCache());
                System.out.println(e.getLocalizedMessage());
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.getLocalizedMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lineParser(String[] args) throws CannotContinueException {
        String[] inputedArgs;
        Options options = LINE_OPTIONS;
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (line.hasOption("h")) {
            String message = "help option selected";
            this.printUsageString(options);
            throw new CannotContinueException("help option selected");
        }
        if (line.hasOption("e")) {
            String optArg = line.getOptionValue("e");
            this.getViewer().setEncoding(optArg);
        }
        if ((inputedArgs = line.getArgs()) == null || inputedArgs.length == 0) {
            String message = "arguments missing !!";
            System.out.println("arguments missing !!");
            System.out.println();
            this.printUsageString(options);
            throw new CannotContinueException("arguments missing !!");
        }
        if (inputedArgs.length != 1) {
            String message = "arguments too many !!";
            System.out.println("arguments too many !!");
            System.out.println();
            this.printUsageString(options);
            throw new CannotContinueException("arguments too many !!");
        }
        File inputFile = new File(StringUtils.yen2Slash(inputedArgs[0]));
        if (!inputFile.exists()) {
            String message = "INPUT FILE is none !!";
            System.out.println("INPUT FILE is none !!");
            System.out.println();
            this.printUsageString(options);
            throw new CannotContinueException("INPUT FILE is none !!");
        }
        if (inputFile.isFile()) {
            this.getViewer().setFile(inputFile);
            return;
        }
        String message = "INPUT FILE is not file!!";
        System.out.println("INPUT FILE is not file!!");
        System.out.println();
        this.printUsageString(options);
        throw new CannotContinueException("INPUT FILE is not file!!");
    }

    private void printUsageString(Options options) {
        System.out.println(this.usageString(options));
    }

    final String usageString(Options options) {
        String usage = "lessThanMore [OPTION]... [INPUT FILE]\n";
        String header = " [OPTIONs]:";
        String footer = "";
        return this.usageString(options, "lessThanMore [OPTION]... [INPUT FILE]\n", " [OPTIONs]:", "");
    }

    private String usageString(Options options, String usage, String header, String footer) {
        HelpFormatter formatter = new HelpFormatter();
        StringWriter sw = new StringWriter();
        formatter.printHelp(new PrintWriter(sw), 74, usage, header, options, 1, 3, footer, false);
        return sw.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void viewLoop(String command) {
        if (StringUtils.isEmpty(command) || "f".equals(command)) {
            String str = this.viewNextPage();
            System.out.println(str);
            return;
        }
        if ("b".equals(command)) {
            String str = this.viewPreviousPage();
            System.out.println(str);
            return;
        }
        if ("h".equals(command)) {
            this.viewLoopUsageString();
            System.out.println(this.viewLoopUsageString());
            return;
        }
        if (command.indexOf("-") == 0 || command.indexOf("+") == 0) {
            int tempInt = 0;
            String numStr = null;
            numStr = command.indexOf("+") == 0 ? command.substring(1) : command;
            try {
                tempInt = Integer.parseInt(numStr);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Input is not number !! ", e);
            }
            this.getPosition().setSkipBytes(tempInt);
            this.getPosition().execute();
            this.getViewCommand().execute();
            System.out.println(this.getViewer().getLastViewCache());
            return;
        }
        if ("q".equals(command) || "exit".equals(command) || "quit".equals(command)) {
            System.exit(0);
            return;
        } else {
            if (command.indexOf("/") != 0 && command.indexOf("?") != 0 && !"n".equals(command) && !"N".equals(command)) return;
            SearchBaseCMD searchCommand = null;
            if (command.indexOf("/") == 0 || command.indexOf("?") == 0) {
                this.nowSearchingKey = command.substring(0, 1);
                this.setSearchWord(command.substring(1));
                searchCommand = command.indexOf("/") == 0 ? new SearchForwardCMD(this.getViewer(), this.getSearchWord()) : new SearchBackwardCMD(this.getViewer(), this.getSearchWord());
            } else {
                if (StringUtils.isEmpty(this.nowSearchingKey)) {
                    throw new IllegalArgumentException("no search word !! ");
                }
                if ("/".equals(this.nowSearchingKey)) {
                    if ("n".equals(command)) {
                        searchCommand = new SearchForwardCMD(this.getViewer(), this.getSearchWord());
                    } else {
                        if (!"N".equals(command)) throw new RuntimeException("unexpected command !! command=" + command);
                        searchCommand = new SearchBackwardCMD(this.getViewer(), this.getSearchWord());
                    }
                } else {
                    if (!"?".equals(this.nowSearchingKey)) throw new RuntimeException("unexpected nowSearchingKey !! nowSearchingKey=" + this.nowSearchingKey);
                    if ("n".equals(command)) {
                        searchCommand = new SearchBackwardCMD(this.getViewer(), this.getSearchWord());
                    } else {
                        if (!"N".equals(command)) throw new RuntimeException("unexpected command !! command=" + command);
                        searchCommand = new SearchForwardCMD(this.getViewer(), this.getSearchWord());
                    }
                }
            }
            searchCommand.execute();
            System.out.println(this.getViewer().getLastViewCache());
        }
    }

    final String viewLoopUsageString() {
        String rtn = this.usageString(VIEW_LOOP_HELP_COMMAND, "command[argument]", "", "");
        rtn = rtn.replace("-", "");
        rtn = rtn.replace("question", "?");
        rtn = rtn.replace("q", "q");
        rtn = rtn.replace("slush", "/");
        rtn = rtn.replace("minus", "-");
        rtn = rtn.replace("plus", "+");
        return rtn;
    }

    static {
        Option help = new Option("h", "help", false, "print this message");
        Option encoding = new Option("e", "encoding", true, "input file encoding. ex)SJIS,UTF-8,EUC_JP ...");
        encoding.setArgName("charsetName");
        LINE_OPTIONS = new Options();
        LINE_OPTIONS.addOption(help);
        LINE_OPTIONS.addOption(encoding);
        help = new Option("h", false, "print this message");
        Option enter = new Option("EnterKey", false, "view next page");
        Option forward = new Option("f", false, "view next page");
        Option backward = new Option("b", false, "view privious page");
        Option plus = new Option("plus", true, "move n byte forward and view page");
        plus.setArgName("byte");
        Option minus = new Option("minus", true, "move n byte backward and view page");
        minus.setArgName("byte");
        Option searchForward = new Option("slush", true, "search forward");
        searchForward.setArgName("search ward");
        Option searchBackward = new Option("question", true, "search backward");
        searchBackward.setArgName("search ward");
        Option quit = new Option("q", false, "quit this aplication");
        VIEW_LOOP_HELP_COMMAND = new Options();
        VIEW_LOOP_HELP_COMMAND.addOption(help);
        VIEW_LOOP_HELP_COMMAND.addOption(enter);
        VIEW_LOOP_HELP_COMMAND.addOption(forward);
        VIEW_LOOP_HELP_COMMAND.addOption(backward);
        VIEW_LOOP_HELP_COMMAND.addOption(plus);
        VIEW_LOOP_HELP_COMMAND.addOption(minus);
        VIEW_LOOP_HELP_COMMAND.addOption(searchForward);
        VIEW_LOOP_HELP_COMMAND.addOption(searchBackward);
        VIEW_LOOP_HELP_COMMAND.addOption(quit);
    }
}

