/*
 * Decompiled with CFR 0.152.
 */
package jp.que.ti.yhj.utils.file;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.que.ti.yhj.utils.file.FileFilter;
import jp.que.ti.yhj.utils.file.FilteredFile;

public class UnnecessaryLocalFileFilter
implements FileFilter {
    private static final Logger LOGGER = Logger.getLogger(UnnecessaryLocalFileFilter.class.getName());
    private List<Pattern> directoryPatterns = new LinkedList<Pattern>();
    private List<Pattern> filePatterns = new LinkedList<Pattern>();
    private static final String[] NULL_STRING_ARRAY = new String[0];

    public boolean isNeed(FilteredFile file) {
        List<Pattern> ptns = null;
        ptns = file.isDirectory() ? this.directoryPatterns : this.filePatterns;
        for (Pattern pattern : ptns) {
            Matcher mt = pattern.matcher(file.getName());
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(mt + "::" + file.getName() + "::" + mt.matches());
            }
            if (!mt.matches()) continue;
            return false;
        }
        return true;
    }

    private void setDirectoryRegularExpressions(String ... patterns) {
        this.directoryPatterns = new LinkedList<Pattern>();
        if (patterns == null) {
            return;
        }
        for (String pattern : patterns) {
            if ("".equals(pattern)) continue;
            this.directoryPatterns.add(Pattern.compile(pattern));
        }
    }

    public void setDirectorySimpleRegularExpressions(String ... patterns) {
        String[] paramPtns = this.simpleRegularExpressions(patterns);
        this.setDirectoryRegularExpressions(paramPtns);
    }

    private String[] simpleRegularExpressions(String ... patterns) {
        if (patterns == null) {
            return NULL_STRING_ARRAY;
        }
        String[] paramPtns = new String[patterns.length];
        for (int idx = 0; idx < patterns.length; ++idx) {
            char[] crs = patterns[idx].toCharArray();
            StringBuilder sb = new StringBuilder(crs.length * 3);
            sb.append("^");
            for (char cr : crs) {
                if (cr == '*') {
                    sb.append(".*");
                    continue;
                }
                sb.append("[");
                sb.append(cr);
                sb.append("]");
            }
            sb.append("$");
            paramPtns[idx] = sb.toString();
        }
        return paramPtns;
    }

    private void setFileRegularExpressions(String ... patterns) {
        this.filePatterns = new LinkedList<Pattern>();
        if (patterns == null) {
            return;
        }
        for (String pattern : patterns) {
            if ("".equals(pattern)) continue;
            this.filePatterns.add(Pattern.compile(pattern));
        }
    }

    public void setFileSimpleRegularExpressions(String ... patterns) {
        String[] paramPtns = this.simpleRegularExpressions(patterns);
        this.setFileRegularExpressions(paramPtns);
    }
}

