package jp.que.ti.yhj.less.than.more.sw;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;

public class UsageInWebListener  extends LessThanMoreBaseActionListener {

	protected URL usageUrl() {
		try {
			return new URL("http://ti.que.jp/p/software/lessthanmore/usage/");
		} catch (MalformedURLException e) {
			final String msg = "ブラウザで\"http://ti.que.jp/p/software/lessthanmore/usage/\"にアクセスする際に想定外のエラーが発生しました";
			getController().getFrame().setStatusMessage(msg);
			throw new RuntimeException(msg);
		}
	}

	@Override
	public void actionPerformed(ActionEvent event) {
        //デフォルトのブラウザーを使ってリンク先を表示
        Desktop dp = Desktop.getDesktop();
        try {
            dp.browse(usageUrl().toURI());
        } catch (URISyntaxException ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
        } catch (IOException ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
        } catch (RuntimeException ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
	}
}
