/*
 * aboutThisDialog.java
 *
 * Created on 2008/09/18, 2:33
 */
package jp.que.ti.yhj.less.than.more.swview;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkEvent.EventType;
import javax.swing.event.HyperlinkListener;

/**
 *
 * @author  kaka
 */
public class AboutThisDialog extends javax.swing.JDialog {

    /** Creates new form aboutThisDialog */
    public AboutThisDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.siteURLPane.addHyperlinkListener(new HyperlinkHandler());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel2 = new javax.swing.JLabel();
        versionNoLabel = new javax.swing.JLabel();
        aboutThisDialogOkBtn = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        siteURLPane = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jLabel2.setText("version");

        versionNoLabel.setText("0.0.0    0000000");

        aboutThisDialogOkBtn.setText("OK");
        aboutThisDialogOkBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                aboutThisDialogOkBtnActionPerformed(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Serif", 0, 18));
        jLabel1.setText("about lessThanMore");

        jLabel3.setText("サイトURL:");

        siteURLPane.setBackground(java.awt.SystemColor.control);
        siteURLPane.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        siteURLPane.setContentType("text/html");
        siteURLPane.setEditable(false);
        siteURLPane.setText("<html><body><a href=\"http://ti.que.jp/p/software/lessthanmore/\">http://ti.que.jp/p/software/lessthanmore/</a></body></html>");
        jScrollPane1.setViewportView(siteURLPane);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(22, 22, 22)
                .addComponent(jLabel2)
                .addGap(28, 28, 28)
                .addComponent(versionNoLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 260, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(20, 20, 20))
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 384, Short.MAX_VALUE)
                .addContainerGap())
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, 55, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 314, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(aboutThisDialogOkBtn, javax.swing.GroupLayout.DEFAULT_SIZE, 384, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(versionNoLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(aboutThisDialogOkBtn)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane1))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void aboutThisDialogOkBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutThisDialogOkBtnActionPerformed
// TODO add your handling code here:
    dispose();
}//GEN-LAST:event_aboutThisDialogOkBtnActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                AboutThisDialog dialog = new AboutThisDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    /**
     * バージョンナンバーを取得します
     * @return バージョンナンバー
     */
    public String getVersionNoString() {
        return versionNoLabel.getText();
    }

    /**
     * バージョンナンバーを設定します
     * @param verNo バージョンナンバー
     */
    public void setVersionNoString(String verNo) {
        versionNoLabel.setText(verNo);
    }

    /**
     * サイトURLのペインを取得します
     * @return サイトURLのペイン
     */
    public javax.swing.JEditorPane getSiteURLPane() {
        return this.siteURLPane;
    }

    static class HyperlinkHandler implements HyperlinkListener {

        private static Logger logger = Logger.getLogger(HyperlinkHandler.class.getName());

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            try {
                if (e.getEventType() == EventType.ACTIVATED) {	//クリックされた時
                    URL url = e.getURL();

                    //デフォルトのブラウザーを使ってリンク先を表示
                    Desktop dp = Desktop.getDesktop();
                    try {
                        dp.browse(url.toURI());
                    } catch (URISyntaxException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    } catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            } catch (RuntimeException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton aboutThisDialogOkBtn;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JEditorPane siteURLPane;
    private javax.swing.JLabel versionNoLabel;
    // End of variables declaration//GEN-END:variables
}
