package jp.que.ti.yhj.testutil;

import java.io.File;
import java.util.LinkedList;
import java.util.List;

/** テストのためのユーティリティークラス */
public class TestUtils {
	/**
	 * svnの管理下にあるディレクトリのパス以下のファイルを除外する。
	 *
	 * @param fileAndDir
	 *            処理対象のファイルのリスト
	 * @return svnの管理下ファイルを除外した後のファイルのリスト
	 */
	public static List<File> removeSvn(List<File> fileAndDir) {
		List<File> rtn = new LinkedList<File>();

		for (File file : fileAndDir) {
			if (matchesSvnDir(file)) { // svnの管理下ディレクトリ以下のパスにマッチするものは除外
			} else {//
				rtn.add(file);
			}
		}
		return rtn;
	}

	final static boolean matchesSvnDir(File file) {
		String rgx = ".*\\.svn.*"; // 文字列：.*\.svn.*
		if (file.getAbsolutePath().matches(rgx)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * テスト準備として、ディレクトリおよびファイルを削除する
	 *
	 * @param path
	 *            削除対象
	 * @return 削除成功の場合 true
	 */
	public static boolean del(String path) {
		File fl = new File(path);
		return del(fl);
	}

	private static boolean del(File fl) {
		if (fl.exists()) {
			if (fl.isDirectory()) {
				File[] childs = fl.listFiles();
				for (int i = 0; i < childs.length; i++) {
					File child = childs[i];
					final boolean tmp = del(child);
					if (!tmp) {// 削除失敗なら、戻り値も削除失敗でリターン
						return tmp;
					}
				}
			}
			final boolean bl = fl.delete();
			return bl;
		} else {
			return true; // 削除対象なし
		}
	}
}
