/*
 * created  2008/06/24 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.command;

import jp.que.ti.yhj.less.than.more.CannotContinueException;
import jp.que.ti.yhj.less.than.more.LessThanMoreCUIController;
import junit.framework.TestCase;

/**
 * {@link LessThanMoreCUIController} を使用して、{@link ViewCMD} をテストする。
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class ViewCMDTest extends TestCase {
	public void test_execute() throws CannotContinueException {
		LessThanMoreCUIController cntl = new LessThanMoreCUIController();
		cntl.lineParser(new String[] { "-e", "EUC-JP",
				"testdata/test-euc-jp.txt" });
		Command cmd = new ViewCMD().setTextViewer(cntl.getViewer());
		cmd.execute();
		String rtn = cntl.getViewer().getLastViewCache();
		assertFalse("読み込み文字列確認 rtn=" + rtn//
		, rtn.indexOf("安以宇衣於1234567890-^") == -1);
	}
}
