/*
 * created  2008/06/16 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.command;

import jp.que.ti.yhj.less.than.more.TextViewer;

/**
 * {@link TextViewer} に対して処理を実行するコマンドの基本機能を提供するクラスです。
 * 
 * @author kaka
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public abstract class Command implements CommandInterface {

	private TextViewer textViewer;

	/**
	 * このオブジェクトが処理対象とする {@link TextViewer} を取得します。
	 * 
	 * @return textViewer このオブジェクトが処理対象とする {@link TextViewer}
	 */
	public final TextViewer getTextViewer() {
		return textViewer;
	}

	/**
	 * このオブジェクトが処理対象とする {@link TextViewer} を設定します。
	 * 
	 * @param textViewer
	 *            このオブジェクトが処理対象とする {@link TextViewer}
	 */
	public Command setTextViewer(TextViewer textViewer) {
		this.textViewer = textViewer;
		return this;
	}

}
