/*
 * EncodingPanel.java
 *
 * Created on 2008/09/12, 22:41
 */

package jp.que.ti.yhj.less.than.more.swview;

import java.nio.charset.Charset;
import javax.swing.JComboBox;

/**
 *
 * @author  kaka
 */
public class EncodingPanel extends javax.swing.JPanel {

    /** Creates new form EncodingPanel */
    public EncodingPanel() {
        initComponents();
        coustomInitComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        encodingLbl = new javax.swing.JLabel();
        encodingCombo = new javax.swing.JComboBox();

        setMaximumSize(new java.awt.Dimension(250, 20));
        setMinimumSize(new java.awt.Dimension(100, 20));
        setPreferredSize(new java.awt.Dimension(180, 20));

        encodingLbl.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        encodingLbl.setText("Encoding");
        encodingLbl.setMaximumSize(new java.awt.Dimension(50, 20));
        encodingLbl.setMinimumSize(new java.awt.Dimension(46, 20));
        encodingLbl.setPreferredSize(new java.awt.Dimension(46, 20));

        encodingCombo.setEditable(true);
        encodingCombo.setFont(new java.awt.Font("DialogInput", 0, 12)); // NOI18N
        encodingCombo.setMaximumSize(new java.awt.Dimension(200, 20));
        encodingCombo.setMinimumSize(new java.awt.Dimension(50, 20));
        encodingCombo.setPreferredSize(new java.awt.Dimension(125, 20));
        encodingCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                encodingComboActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(encodingLbl, javax.swing.GroupLayout.PREFERRED_SIZE, 59, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(encodingCombo, 0, 116, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(encodingCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(encodingLbl, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void encodingComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_encodingComboActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_encodingComboActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox encodingCombo;
    private javax.swing.JLabel encodingLbl;
    // End of variables declaration//GEN-END:variables

    /**
     * エンコーディングを指定するためのコンボボックスの gettere
     * @return エンコーディングを指定するためのコンボボックス
     */
    public JComboBox getEncodingCombo() {
        return encodingCombo;
    }

    /** このコンポーネントの初期化(独自拡張) */
    private void coustomInitComponents() {
        final String dflt = Charset.defaultCharset().name();
        getEncodingCombo().addItem(dflt);
        String[] encs = new String[]{"US-ASCII", "Cp1252", "ISO-8859-1", "ISO-8859-15", "ISO8859_1", "UnicodeBig", "UnicodeBigUnmarked", "UnicodeLittle", "UnicodeLittleUnmarked", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-8", "UTF8", "EUC_JP", "MS932", "SJIS"};
        for (int idx = 0; idx < encs.length; idx++) {
            final String enc = encs[idx];
            if (dflt.equals(enc)) {
            } else {
                getEncodingCombo().addItem(enc);
            }
        }
        getEncodingCombo().setSelectedIndex(0);
    }
}
