package jp.que.ti.yhj.utils;

import java.util.Properties;

import jp.que.ti.yhj.utils.PropertiesUtils;
import junit.framework.TestCase;

public class PropertiesUtilsTest extends TestCase {
	Properties prop = null;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		prop = new Properties();
	}

	public void testGetProperty() {
		String expected = null;
		String propKey = null;

		// プロパティーから値を取得する機能をテスト
		propKey = "hoge";
		expected = "hogeVal";
		prop.setProperty(propKey, expected);
		assertEquals(expected//
				, PropertiesUtils.getProperty(propKey, prop));

		expected = "sysPropVal";
		System.setProperty(propKey, expected);
		assertEquals("システムプロパティーが優先されること", expected//
				, PropertiesUtils.getProperty(propKey, prop));
		System.getProperties().remove(propKey);// テスト用システムプロパティーを掃除

		// 値がない場合のテスト
		assertNull(PropertiesUtils.getProperty("notExsist", prop));
	}

	public void testGetFilePathProperty() {
		String val = null;
		String expected = null;
		String propKey = null;

		// プロパティーから値を取得する機能をテスト
		propKey = "hoge";
		val = "\\a\\b.text";
		expected = "/a/b.text";
		prop.setProperty(propKey, val);
		assertEquals(expected//
				, PropertiesUtils.getFilePathProperty(propKey, prop));

		val = "\\a\\b/system\\prop/file.txt";
		expected = "/a/b/system/prop/file.txt";
		System.setProperty(propKey, val);
		assertEquals("システムプロパティーが優先されること", expected//
				, PropertiesUtils.getFilePathProperty(propKey, prop));
		System.getProperties().remove(propKey);// テスト用システムプロパティーを掃除

		// 値がない場合のテスト
		assertNull(PropertiesUtils.getFilePathProperty("notExsist", prop));
	}

}
