package jp.que.ti.yhj.utils.file;

import java.io.File;

import jp.que.ti.yhj.utils.file.FilteredLocalFile;
import jp.que.ti.yhj.utils.file.UnnecessaryLocalFileFilter;
import junit.framework.TestCase;

/** {@link UnnecessaryLocalFileFilter}のテストクラス */
public class UnnecessaryLocalFileFilterTest extends TestCase {
	private UnnecessaryLocalFileFilter filter;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		filter = new UnnecessaryLocalFileFilter();
	}

	/** {@link UnnecessaryLocalFileFilter#isNeed(FilteredFile)}のテスト */
	public void testIsNeed() {
		final File fileSVN = new File("testdata/.svn");
		FilteredLocalFile ffl = new FilteredLocalFile(fileSVN);

		if (fileSVN.exists()) { // このテストを継続する
		} else { // このテストはスキップする
			return;
		}

		filter.setDirectorySimpleRegularExpressions(".svn");
		filter.setFileSimpleRegularExpressions((String[]) null);
		assertFalse("不要ファイルの判定のはず", filter.isNeed(ffl));
		filter.setDirectorySimpleRegularExpressions((String[]) null);
		filter.setFileSimpleRegularExpressions(".svn");
		assertTrue("要ファイルの判定のはず", filter.isNeed(ffl));

		filter.setDirectorySimpleRegularExpressions("cvs", ".svn");
		filter.setFileSimpleRegularExpressions((String[]) null);
		assertFalse("不要ファイルの判定のはず", filter.isNeed(ffl));
		filter.setDirectorySimpleRegularExpressions((String[]) null);
		filter.setFileSimpleRegularExpressions("cvs", ".svn");
		assertTrue("要ファイルの判定のはず", filter.isNeed(ffl));

		filter.setDirectorySimpleRegularExpressions("c*s", ".*vn");
		filter.setFileSimpleRegularExpressions((String[]) null);
		assertFalse("不要ファイルの判定のはず", filter.isNeed(ffl));
		filter.setDirectorySimpleRegularExpressions((String[]) null);
		filter.setFileSimpleRegularExpressions("c*s", ".s*n");
		assertTrue("要ファイルの判定のはず", filter.isNeed(ffl));

		filter.setDirectorySimpleRegularExpressions("cvs", ".sv*");
		filter.setFileSimpleRegularExpressions((String[]) null);
		assertFalse("不要ファイルの判定のはず", filter.isNeed(ffl));
		filter.setDirectorySimpleRegularExpressions((String[]) null);
		filter.setFileSimpleRegularExpressions("cvs", ".sv*");
		assertTrue("要ファイルの判定のはず", filter.isNeed(ffl));
	}
}
