/*
 * created  2008/07/07 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.command;

import java.util.logging.Level;
import java.util.logging.Logger;

import jp.que.ti.yhj.less.than.more.TextViewer;

/**
 * 現在の位置を、前ページ読み込み位置に変更しテキストの内容を取得する命令
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class PriviousPagePositionCMD extends Command {
	private final Logger log = Logger.getLogger(getClass().getName());

	/**
	 * @param positionCommand
	 */
	public PriviousPagePositionCMD() {
		super();
	}

	@Override
	public Command setTextViewer(TextViewer textViewer) {
		return super.setTextViewer(textViewer);
	}

	/**
	 * {{@link #getTextViewer()} の現在の位置を、前ページ読み込み位置に変更し、テキストファイルから文字列を読み込みます。
	 */
	@Override
	public void execute() {
		if (getTextViewer().getFile() == null) {
			final String msg = "file is null";
			throw new RuntimeException(msg);
		}

		if (getTextViewer().getPosition() <= 0) {
			throw new IllegalPositionException("前ページはありません");
		}

		long startPos = getTextViewer().getPosition()
				- getTextViewer().getReadingLength();

		byte[] tmp4Fwd = null;
		byte[] tmp4Bck = null;
		if (startPos < 0) {
			startPos = 0;
		} else {
			tmp4Fwd = getTextViewer().readLineForward(startPos);
			final int tmp4FwdLen = tmp4Fwd.length;

			if (tmp4FwdLen < getTextViewer().getReadingLength()) {
				startPos = startPos + tmp4FwdLen;
			} else {
				tmp4Bck = getTextViewer().readLineBackward(startPos);
				startPos = startPos - tmp4Bck.length + 1;
			}
		}

		// log start
		if (log.isLoggable(Level.FINEST)) {
			String fwd = null;
			if (tmp4Fwd != null) {
				fwd = tmp4Fwd.length + "";
			}
			String bck = null;
			if (tmp4Bck != null) {
				bck = tmp4Bck.length + "";
			}
			final String msg = //
			"startPos=" + startPos + ":tmp4Fwd.len" + fwd + ":tmp4Bck.length="
					+ bck;
			log.log(Level.FINEST, msg);
		}// log end

		getTextViewer().setPosition(startPos);
		getTextViewer().view();
	}
}
