package jp.que.ti.yhj.utils.file;

import java.io.File;

/**
 * {@link File}を{@link FilteredFile}型にラップしたクラス。<br>
 * {@link File}を{@link FileFilter}でフィルターするために使用する
 * 
 * @author Hajime.Yanagawa
 * @author $Author: yanagawa.hajime $ (last modified)
 * @version $Revision: $
 */
public class FilteredLocalFile implements FilteredFile {
	private File file;

	/** コンストラクタ */
	public FilteredLocalFile() {
	}

	/**
	 * コンストラクタ
	 * 
	 * @param file
	 *            ラップする{@link File}
	 */
	public FilteredLocalFile(File file) {
		setFile(file);
	}

	/** @see jp.que.ti.yhj.utils.file.FilteredFile#getName() */
	public String getName() {
		return file.getName();
	}

	/** @see jp.que.ti.yhj.utils.file.FilteredFile#isDirectory() */
	public boolean isDirectory() {
		return file.isDirectory();
	}

	/**
	 * ラップした{@link File}の getter
	 * 
	 * @return ラップした{@link File}
	 */
	public final File getFile() {
		return file;
	}

	/**
	 * ラップする{@link File}の setter
	 * 
	 * @param file
	 *            ラップする{@link File}
	 */
	public final void setFile(File file) {
		this.file = file;
	}

}
