package jp.que.ti.yhj.less.than.more.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import junit.framework.TestCase;

/**
 * {@link EncodingUtils}のテストクラス
 *
 * @author yhj
 */
public class EncodingUtilsTest extends TestCase {
	/** {@link EncodingUtils#ditectEncodingString(byte[])}のテスト */
	public void testDitectEncodingString() {
		byte[] buf = null;
		String fNam = null;

		buf = new byte[1024];
		fNam = "testdata/test-euc-jp.txt";
		buf = readFile(fNam, buf);
		assertEquals(EncodingUtils.EUC_JP //
				, EncodingUtils.ditectEncodingString(buf));

		buf = new byte[1024];
		fNam = "testdata/test-sjis.txt";
		buf = readFile(fNam, buf);
		assertEquals(EncodingUtils.WINDOWS_31J //
				, EncodingUtils.ditectEncodingString(buf));

		buf = new byte[1024];
		fNam = "testdata/test-utf-8.txt";
		buf = readFile(fNam, buf);
		assertEquals(EncodingUtils.UTF_8 //
				, EncodingUtils.ditectEncodingString(buf));

	}

	private byte[] readFile(String filePath, byte[] readBuffer) {
		FileInputStream fis;
		try {
			fis = new FileInputStream(filePath);
		} catch (FileNotFoundException e) {
			throw new RuntimeException(e);
		}
		try {
			fis.read(readBuffer);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		return readBuffer;
	}
}
